package com.rameses.entity.models;

import com.rameses.rcp.annotations.*;
import com.rameses.rcp.common.*;
import com.rameses.osiris2.client.*;
import com.rameses.osiris2.common.*;
import com.rameses.seti2.models.CrudListModel;

class JuridicalEntityListModel extends CrudListModel {
    
    def confs = [
        'entityno'     : [ width: 120 ],
        'entityname'   : [ visible: false ], 
        'name'         : [ width: 400 ], 
        'address.text' : [ width: 400 ], 
        'orgtype'      : [ width: 100 ]
    ]; 
    
    boolean autoResize = false; 
    
    public void initColumn( def c ) { 
        
        def conf = confs.get( c.name ); 
        if ( !conf ) return; 
        
        if ( conf.type != null ) c.type = conf.type;
        if ( conf.width != null ) c.width = conf.width; 
        if ( conf.minWidth != null ) c.minWidth = conf.minWidth; 
        if ( conf.maxWidth != null ) c.maxWidth = conf.maxWidth; 
        if ( conf.visible != null ) c.visible = conf.visible; 
        if ( conf.caption != null ) c.caption = conf.caption; 
    } 
    
    def getOrgtypes() { 
        return selectedNode?.orgtypes; 
    }
    
    def _orgtype;
    def getOrgtype() { return _orgtype; }
    void setOrgtype( value ) {
        query.orgtype = value; 
        listHandler.doSearch();
        _orgtype = value; 
    }
}
