package com.rameses.gov.etracs.obo.occupancy.models;

import com.rameses.rcp.annotations.*;
import com.rameses.rcp.common.*;
import com.rameses.seti2.models.*;
import com.rameses.osiris2.common.*;
import com.rameses.util.*;
import com.rameses.osiris2.client.*;
import com.rameses.gov.etracs.obo.models.*;

class OccupancytCertificateModel extends OboAppFormModel  {

    def setInspectionDate() {
        def h = { o->
            def m = [_schemaname: "occupancy_certificate"];
            m.objid = entity.objid;
            m.inspectiondate = o.date + " " + o.hour + ":" + o.minute;
            persistenceService.update( m );
            reload();
        };
        def d = entity.inspectiondate;
        return Inv.lookupOpener("date:prompt", [handler: h, title:"Enter Inspection Date/Time", date:d, includeTime:true]);
    }
    
   
    def viewRpu() {
        def op = Inv.lookupOpener( "vw_occupancy_rpu:open", [entity:[objid:entity.rpuid]] );
        op.target = "popup";
        return op;
    }
}


