package com.rameses.gov.etracs.obo.occupancy.models;

import com.rameses.rcp.annotations.*;
import com.rameses.rcp.common.*;
import com.rameses.seti2.models.*;
import com.rameses.osiris2.common.*;
import com.rameses.util.*;
import com.rameses.osiris2.client.*;

class OccupancyCertificateEditModel  {
    
    @Service("PersistenceService")
    def persistenceSvc;

    @Service("QueryService")
    def querySvc;
    
    @Binding
    def binding;
    
    @Caller
    def caller;
    
    def txnTypes = ["SIMPLE", "COMPLEX", "HIGHLY TECHNICAL"]; 
    def appTypes = ["FULL", "PARTIAL"]; 
    
    String title = "Occupancy Certificate Edit Info";
    
    def entity;
    def editContext;
    def occupancyStates;
    
    @PropertyChangeListener
    def listener = [
        "entity.total(material|directlabor|equipment|other)cost" : { o->
            entity.actualprojectcost = entity.totalmaterialcost+entity.totaldirectlaborcost+entity.totalequipmentcost+entity.totalothercost;
            binding.refresh("entity.actualprojectcost");
        }
    ];
    
    void init(def inv) {
        editContext = inv.properties.context;
        def _old = entity;
        entity = [_schemaname:"occupancy_certificate"];
        entity.objid = _old.objid;
        
        if(editContext == "txntype" ) {
            entity.txntype = _old.txntype;
        }
        else if(editContext == "apptype" ) {
            entity.apptype = _old.apptype;
        }
        else if(editContext == "occupancystate" ) {
            def m = [_schemaname:"obo_lookupvalue"];
            m.where = [ "listname = :ln", [ln: "OCCUPANCYSTATE"]];
            m.orderBy = "sortorder";
            occupancyStates = querySvc.getList(m);
            entity.occupancystateid = _old.occupancystateid;
        }        
        else if(editContext == "contact") {
            entity.contact = _old.contact;
        }
        else if(editContext == "project") {
            entity.bldgpermit = _old.bldgpermit;
            entity.actualnumunits = _old.actualnumunits;
            entity.actualnumfloors = _old.actualnumfloors;
            entity.actualtotalfloorarea = _old.actualtotalfloorarea;
            entity.actualheight = _old.actualheight;
            entity.totalmaterialcost = _old.totalmaterialcost;
            entity.totaldirectlaborcost = _old.totaldirectlaborcost;
            entity.totalequipmentcost = _old.totalequipmentcost;
            entity.totalothercost = _old.totalothercost;
            entity.actualprojectcost = _old.actualprojectcost;
            entity.dtactualstarted = _old.dtactualstarted;
            entity.dtactualcompleted = _old.dtactualcompleted;
        }
        else if(editContext == "supervisor") {
            entity.supervisor = _old.supervisor;
        }
        else if(editContext == "contractor") {
            entity.contractor = _old.contractor;
        }
        else if(editContext == "applicant") {
            entity.applicant = _old.applicant;
        }
        else if(editContext== "occupancytype" ) {
            entity.occupancytype = _old.occupancytype;            
        }
         else if(editContext=="tags") {
            entity.tags = _old.tags;
        }
    }
    
    def lookupApplicant() {
        def p = [:];
        p.handler = { o->
            entity.applicant = o;
            binding.refresh();
        }
        if( entity.applicant ) {
            p.entity = entity.applicant;
            p.applicant = [name: entity.applicant.name ];            
        }
        else {
            p.entity = [:];
            p.applicant = null;
        }
        return Inv.lookupOpener("obo_app_entity", p );
    }
    
    def editContractor() {
        def h = { e->
            entity.contractor = e;
            binding.refresh("entity.contractor.*");
        }
        return Inv.lookupOpener("occupancy_contractor", [entity: entity.contractor, editable: true, handler: h ]);
    }

    def selectedTag;

    def addTag() {
        def s = { o->
            if( !entity.tags.find{it.tagid == o.objid }) {
                def m = [:];
                m.appid = entity.objid;
                m.tagid = o.objid;
                entity.tags << m;
                binding.refresh();                    
            }
        }
        return Inv.lookupOpener("obo_tag:lookup", [onselect:s]);
    }

    void removeTag() {
        if(!selectedTag) throw new Exception("Please select an entry");
        if(!entity._removedtags) entity._removedtags = [];
        entity._removedtags << selectedTag;
        entity.tags.remove( selectedTag );
        binding.refresh();
    }

    public void beforeSave( def o )  {
    }
    
    public def doOk() {
        if(!MsgBox.confirm("You are about to update the changes. Proceed?")) return null;
        persistenceSvc.update(entity);
        if(caller) caller.reloadEntity();
        return "_close";
    }
    
    public def doCancel() {
        return "_close";        
    }

    
}