package com.rameses.gov.etracs.obo.occupancy.models;

import com.rameses.rcp.annotations.*;
import com.rameses.rcp.common.*;
import com.rameses.seti2.models.*;
import com.rameses.osiris2.common.*;
import com.rameses.util.*;
import com.rameses.osiris2.client.*;

class OccupancyCertificateCreateModel {
    
    @Service("OboAppService")
    def appSvc;
    
    @Service("BuildingPermitService")
    def svc;
    
    def txnTypes = ["SIMPLE","COMPLEX", "HIGHLY TECHNICAL"];
    def appTypes = ["FULL", "PARTIAL"];
    
    boolean hascontractor;
    def permitno;
    def txnmode;
    def taskstate;
    def page;
    
    String title = "Occupancy Certificate Application (Manual Capture)";
    String schemaName = "vw_occupancy_certificate";
    String entitySchemaName = "occupancy_certificate";

    def entity;
    
    @PropertyChangeListener
    def listener = [
        "entity.total(material|directlabor|equipment|other)cost" : { o->
            entity.actualprojectcost = entity.totalmaterialcost+entity.totaldirectlaborcost+entity.totalequipmentcost+entity.totalothercost;
            binding.refresh("entity.actualprojectcost");
        }
    ];
    
    def create() {
        entity = [:];
        entity.contact = [:];
        if(taskstate) entity.task = [state:taskstate];
        page = "initial";
        return page;
    }
    
    def back() {
        page = "initial";
        return page;
    }
    
    def next() {
        def permit = svc.findByPermitNo( [permitno: permitno] );
        if(!permit) throw new Exception("Building Permit not found");
        if(permit.task.state!='end')
            throw new Exception("This permit is not yet completed. It is still in " + permit.task.title );

        entity.bldgpermit = permit;
        entity.txntype = permit.txntype;
        entity.applicant = permit.applicant;
        entity.occupancytype = permit.occupancytype;
        entity.actualnumunits = permit.numunits;
        entity.actualnumfloors = permit.numfloors;
        entity.actualtotalfloorarea = permit.totalfloorarea;
        entity.actualheight = permit.height;
        entity.supervisor = permit.supervisor;
        entity.totalmaterialcost = 0;
        entity.totaldirectlaborcost = 0;
        entity.totalequipmentcost = 0;
        entity.totalothercost = 0;
        entity.actualprojectcost = 0;
        entity.txnmode = txnmode;
        page = "view";
        return page;
    }
    
    /*
    def viewLocation() {
        def p = [:];
        p.entity = entity.location;
        if( !p.entity ) p.entity = [:];
        p.handler = { o->
            entity.location = o;
            binding.refresh();
        }
        return Inv.lookupOpener("occupancy_certificate_location", p);
    }
    */
    
    def editContractor() {
        def h = { o->
            entity.contractor = o;
            binding.refresh()
        }
        return Inv.lookupOpener("occupancy_contractor", [entity: entity.contractor, handler: h])
    }
    
    public def save() {
        if( !entity.applicant ) throw new Exception("Applicant is required");
        if( !entity.supervisor ) throw new Exception("supervisor is required");
        entity.appclass = "occupancy_certificate";
        entity = appSvc.create( entity );
        def op =  Inv.lookupOpener("vw_occupancy_certificate:open", [entity: entity ] );
        op.target = "topwindow";
        return op;                
    }
    

    
}