package com.rameses.gov.etracs.obo.building.models;

import com.rameses.rcp.annotations.*;
import com.rameses.rcp.common.*;
import com.rameses.osiris2.client.*;
import com.rameses.osiris2.common.*;
import com.rameses.seti2.models.*;


class OccupancyCertificateAppInfoModel {

    @Service("PersistenceService")
    def persistenceService;

    @Caller
    def caller;

    @Binding
    def binding;
    
    def getEntity() {
        return caller.entity;
    }
    
    def viewApplicant() {
        def p = [:];
        p.editable = false;
        p.applicant = [name: entity.applicant.name ];
        p.entity = entity.applicant;
        return Inv.lookupOpener("obo_app_entity", p);
    }

    def editContractor() {
        return Inv.lookupOpener("occupancy_contractor", [entity: entity.contractor, editable: false])
    }
    
    def getTags() {
        return entity.tags*.tagid.join(",");    
    }
    
    def viewRpu() {
        def op = Inv.lookupOpener( "vw_occupancy_rpu:open", [entity:[objid:entity.rpuid]] );
        op.target = "popup";
        return op;
    }

    def getShowSetInspectionDate() {
        return entity.task.state.matches('schedule.*') && caller.userTaskAssignee == true;        
    }

    def setInspectionDate() {
        def h = { o->
            def m = [_schemaname: "occupancy_certificate"];
            m.objid = entity.objid;
            m.inspectiondate = o.date + " " + o.hour + ":" + o.minute;
            persistenceService.update( m );
            entity.inspectiondate = m.inspectiondate;
            binding.refresh();
        };
        def d = entity.inspectiondate;
        return Inv.lookupOpener("date:prompt", [handler: h, title:"Enter Inspection Date/Time", date:d, includeTime:true]);
    }
    
    
}
