package ireport.designer.models;

import com.rameses.rcp.annotations.*;
import com.rameses.rcp.common.*;
import com.rameses.osiris2.client.*;
import com.rameses.osiris2.common.*;
import com.rameses.osiris2.reports.*;

public class IReportDesignerShowModel  {

    ReportModel reportModel;
    def reportTemplateService;
    def filePath; 
    
    SysReportTemplate reportTemplate; 
    SysReportTemplateClassLoader reportTemplateClassLoader; 
    
    void init(){ 
        if ( reportModel == null ) {
            throw new Exception("'reportModel' must be provided");
        }
        if ( reportTemplateService == null ) {
            throw new Exception("'reportTemplateService' must be provided");
        }
        if ( !filePath ) {
            throw new Exception("'filePath' must be provided");
        }
        
        def storefiles = []; 
        def custom_dir = null; 
        def workspace_dir = IReportDesigner.getConfig().getWorkspaceDir();
        if ( workspace_dir ) {
            custom_dir = new java.io.File( workspace_dir ); 
        } else {
            custom_dir = IReportDesigner.getConfig().getCustomDir();
        }
        
        reportTemplate = new SysReportTemplate( custom_dir.getCanonicalPath(), filePath ); 
        storefiles = reportTemplate.sync( templateSource, true );
        
        reportTemplateClassLoader = new SysReportTemplateClassLoader( reportTemplate ); 

        def jrxmls = storefiles.findAll{( it.name.toString().endsWith(".jrxml") )}
        if ( !jrxmls ) 
            throw new IllegalStateException("This template does not have any jrxml file");
        
        def jrmain = jrxmls.find{( it.main == 1 )} 
        if ( !jrmain ) 
            throw new IllegalStateException("This template does not have a main report file");
        
        def _files = []; 
        _files << new java.io.File( custom_dir, jrmain.name );
        
        jrxmls.findAll{( it.main == 0 )}.each{
            _files << new java.io.File( custom_dir, it.name );
        }

        def _report_model = reportModel;
        
        def irm = [
            
            getReportModel: {
                return _report_model; 
            },
            getFiles: {
                return _files; 
            },
            upload: {
                return _doUpload();
            },
            download: {
                _doDownload();
            },
            showImageList: {
                _showImageList();
            }
            
        ] as IReportDesignerModel; 
        
        IReportDesigner.show( irm ); 
    } 
    
    def templateSource = [

        getContent: { id->
            return reportTemplateService.getContent([ name: id ]);
        },
        saveContent: { id,bytes,lastmod->
            reportTemplateService.saveContent([ name: id, content: bytes, lastmodified: lastmod ]); 
        },
        getResources: { id->
            return reportTemplateService.getResources([ name: id ]);
        }

    ] as SysReportTemplateSource;
    
    
    private boolean _doUpload() { 
        try {
            reportTemplate.upload( templateSource, true ); 
            MsgBox.alert("Successfully uploaded");
            return true; 
        }
        catch(Throwable t) {
            MsgBox.err( t ); 
            return false; 
        }
    }
    
    private void _doDownload() {
    }
    
    private void _showImageList() {
        def param = [:]; 
        param.reportModel = reportModel;
        param.reportTemplateService = reportTemplateService; 
        
        def op = Inv.lookupOpener("ireport_designer_image_list:show", param); 
        op.target = "popup";

        Inv.invoke( op ); 
    }
}