package ireport.designer.models;

import com.rameses.rcp.annotations.*;
import com.rameses.rcp.common.*;
import com.rameses.osiris2.client.*;
import com.rameses.osiris2.common.*;
import com.rameses.osiris2.reports.*;
import java.io.File;

public class IReportDesignerImageListModel  {

    @Binding
    def binding;
    
    ReportModel reportModel;
    def reportTemplateService;

    SysReportTemplate reportTemplate; 
    File images_dir;
    String fileseparator;
    String mode;

    void init(){ 
        if ( reportModel == null ) {
            throw new Exception("'reportModel' must be provided");
        }
        if ( reportTemplateService == null ) {
            throw new Exception("'reportTemplateService' must be provided");
        }
                
        mode = "list";

        def custom_dir = null; 
        def workspace_dir = IReportDesigner.getConfig().getWorkspaceDir();
        if ( workspace_dir ) {
            custom_dir = new java.io.File( workspace_dir ); 
        } else {
            custom_dir = IReportDesigner.getConfig().getCustomDir();
        }

        reportTemplate = new SysReportTemplate( custom_dir.getCanonicalPath() );
        images_dir = new java.io.File( custom_dir, "images");
        fileseparator = System.getProperty("file.separator", File.separator); 
    }
    
    def selectedItem;
    def listHandler = [
        
        fetchList: { o-> 
            return reportTemplateService.getImages(); 
        }
        
    ] as DataListModel;
    
    void refresh() {
        listHandler.reload(); 
    }
    
    void download(){
        if ( selectedItem == null ) {
            MsgBox.alert("Please select an item first");
            return;
        }
        
        if ( !selectedItem.name ) {
            throw new Exception("'selectedItem.name' must be provided");
        }
        
        def sel_item = selectedItem; 
        byte[] bytes = reportTemplateService.getContent( sel_item ); 
        if ( bytes == null ) {
            throw new Exception("no available content for resource '"+ selectedItem.name +"'");
        }
        
        reportTemplate.saveResource( sel_item.name, bytes ); 
        MsgBox.alert("Successfully downloaded"); 
    }
        
    
    File imageFile;
    String imageTargetPath;
    String imageTargetFilePath; 
    
    void setImageFile( File file ) {
        this.imageFile = file; 
        buildTargetFilePath();
        binding.notifyDepends("imageInfo");
    }
    void setImageTargetPath( String path ) {
        this.imageTargetPath = path;
        buildTargetFilePath();
        binding.notifyDepends("imageInfo");
    }
    
    def upload() {
        mode = "upload"; 
        imageFile = null; 
        imageTargetPath = "/images";
        imageTargetFilePath = " ";
        return mode; 
    }  
    
    private String buildTargetFilePath() {
        def context_dir = new File( fileseparator, resolveFilePath( imageTargetPath )); 
        def fileName = (imageFile == null ? null : imageFile.getName()); 
        imageTargetFilePath = new File( context_dir, fileName ).getPath();
        return resolveFilePath( imageTargetFilePath ); 
    }
    
    private String resolveFilePath( def path ) {
        if ( !path ) return "";
        
        return path.replace("\\", fileseparator).replace("/", fileseparator);         
    }
    
    
    def cancelUpload() {
        mode = "list"; 
        return "default"; 
    }
    
    def submitUpload() {
        if ( imageFile == null )
            throw new IllegalArgumentException("Image File must be provided first");
        if ( !imageTargetPath )
            throw new IllegalArgumentException("Target Folder must be provided first");

        String filepath = buildTargetFilePath();
        
        byte[] bytes = com.rameses.io.IOStream.toByteArray( imageFile ); 
        reportTemplateService.uploadImage([ name: filepath, bytes: bytes ]); 
        MsgBox.alert("Image successfully uploaded"); 
        
        listHandler.reload();

        mode = "list"; 
        return "default"; 
    }    
}