package com.rameses.rulemgmt.models;

import com.rameses.rcp.common.*;
import com.rameses.rcp.annotations.*;
import com.rameses.osiris2.client.*;
import com.rameses.osiris2.common.*
import com.rameses.rulemgmt.*;
import com.rameses.util.*;
import java.rmi.server.*;
import com.rameses.io.*;
        
class RuleImportModel { 
        
    @Caller
    def caller;

    def getService() {
        InvokerProxy.instance.create("RuleExporterService", null, caller.getConnection() );
    }
        
    def ruleset;
    def file;
    def list = [];
    def selectedItem;
            
    def listModel = [
        fetchList: { o->
            return list;
        }
    ] as BasicListModel;
            
    @PropertyChangeListener
    def listener = [
                "file": { o->
            list.clear();
            def mlist = FileUtil.readObject( file );
            mlist.each {
                list << [ item:it, name:it.name, status:'']; 
            }
            listModel.reload();
        }
    ]
            
    void startImport() {
        if(!list) 
        throw new Exception("Please select a file to import");
        if( !MsgBox.confirm('You are about to transfer the rules to the target rulebase. Proceed?')) return;
        list.each {
            upload( it );
        }
        listModel.reload();
        MsgBox.alert('Successfully imported');
    }
            
    void repostError() {
        if(!selectedItem) return;
        if( selectedItem.state == 'OK' ) return;
        upload( selectedItem );
    }

    void upload( def r ) {
        try {
            service.upload( r.item );
            r.state = 'OK';
        }
        catch(Exception e ) {
            r.state = 'ERR: ' + e.message;
        }
        listModel.refresh();
    }
            
    def doClose() {
        return "_close";
    }
            
}