package com.rameses.gov.etracs.obo.models;

import com.rameses.rcp.annotations.*;
import com.rameses.rcp.common.*;
import com.rameses.seti2.models.*;
import com.rameses.osiris2.common.*;
import com.rameses.util.*;
import com.rameses.osiris2.common.*;
import com.rameses.rcp.common.*;
import com.rameses.osiris2.client.*;
import com.rameses.enterprise.models.*;

class OboVariableModel extends CrudFormModel {
    
    def docTypeList;
    def datatypes = ['integer','decimal','boolean','string','text', 'date', 'lookup', 'array']
    def lookupList;
    boolean fromDocType;
    
    public void afterInit() {
        def m = [_schemaname: "vw_obo_doctype"];
        m.where = ["1=1"];
        docTypeList = queryService.getList(m);
        if(caller.schemaName == "obo_doctype") fromDocType = true;
    }
    
    void afterCreate() {
        if(caller.schemaName=="obo_doctype") {
            entity.doctypeid = caller.entity.code;
        }
        else {
            entity.doctypeid =  caller.selectedNode.id;
        }
        entity.arrayvalues = [];
    }
    
    void initLookupList() {
        def m = [_schemaname: "obo_lookupvalue"];
        m._limit = 1000;
        m.select = "listname";
        m.groupBy = "listname";
        lookupList = queryService.getList(m)*.listname;
    }
    
    void afterOpen() {
        if(entity.datatype == "lookup") initLookupList();
    }
    
    @PropertyChangeListener
    def listener = [
        "entity.name" : { o->
            entity.objid = o;
        },
        "entity.datatype" : { o->
            if( o == "lookup") {
                if(!lookupList) {
                    initLookupList();
                }
                else {
                    entity.lookuplistname = null;
                }
            }
            if( o != 'array' ) {
                entity.arrayvalues = null;
            }
            else {
                entity.arrayvalues = [];
            }
        }
    ];
    
    
    def selectedListItem;
    void addListItem() {
        def r = MsgBox.prompt("Add Item");
        if(!r) return;
        if(entity.arrayvalues==null) entity.arrayvalues = [];
        entity.arrayvalues << r.toUpperCase();
    }
    
    void removeListItem() {
        if(!selectedListItem) return;
        if(entity.arrayvalues==null) entity.arrayvalues = [];        
        entity.arrayvalues.remove( selectedListItem ); 
    }
    
}