package com.rameses.gov.etracs.obo.models;

import com.rameses.rcp.annotations.*;
import com.rameses.rcp.common.*;
import com.rameses.seti2.models.*;
import com.rameses.util.*;
import com.rameses.osiris2.common.*;
import com.rameses.osiris2.client.*;

public class OboUpdateAppFromCloudModel {

	@Service("OboAppCloudInitialService")
	def appCloud;

	@Service("OboAppService")
	def appSvc;

	@Invoker
	def invoker;

	@Caller
	def caller;

    void reloadFromCloud() {
        if(!MsgBox.confirm("You are about to update the data from the cloud. Proceed? "))
            throw new BreakException();

    	def m = [:];
    	m.appclass = invoker.properties.appclass;	
    	m.trackingno = caller.entity.trackingno;
    	m.action = "update";

    	def app = appCloud.getApplication( m );
    	
    	app.appclass = m.appclass;
    	appSvc.update( app );
    	MsgBox.alert("update complete!");
    	caller.reloadEntity();
    }    


}


