package com.rameses.gov.etracs.obo.models;

import com.rameses.rcp.annotations.*;
import com.rameses.rcp.common.*;
import com.rameses.seti2.models.*;
import com.rameses.osiris2.common.*;
import com.rameses.util.*;
import com.rameses.osiris2.common.*;
import com.rameses.rcp.common.*;
import com.rameses.osiris2.client.*;
import com.rameses.enterprise.models.*;
import com.rameses.gov.etracs.obo.models.*;


class OboTaskitemTypeModel extends CrudFormModel {

    def selectedItem;
    def sectionList;
    
    def roleStateList;
    def stateList;
    def processList;
    def prefix;
    def appclassList;

    @PropertyChangeListener
    def listener = [
        "entity.processname" : { o->
            entity.customroles.each { r->
                removeItem("customroles", r );
            }
            entity.customroles = [];
            roleListModel.reload();
            loadRoleStateList(); 
        },
        "entity.parentprocessname": { o->
            loadStateList();
            entity.activationstate = null;
        }
    ];
    
    void loadProcessList() {
        def m = [_schemaname:"sys_wf"];
        m.where = ["1=1"];
        processList = queryService.getList(m)*.name;   
    }

    void loadStateList() {
        def m = [_schemaname:"sys_wf_node"];
        m.where = ["processname =:pname AND nodetype = 'state' AND tracktime=1 ", [pname:entity.parentprocessname]];
        m.select = "name";
        m.orderBy = "idx";
        stateList = queryService.getList(m)*.name;   
    }

    void loadSections() {
        //load sections
        def m1 = [_schemaname: "obo_section"];
        m1.where = ["1=1"];
        sectionList = queryService.getList(m1);    
    }

    void loadAppclassList() {
        def m = [_schemaname:"obo_appclass"];
        m.where = ["1=1"];
        appclassList = queryService.getList(m)*.objid;          
    }

    void loadRoleStateList() {
        def m = [_schemaname:"sys_wf_node"];
        m.where = ["processname=:pname AND nodetype = 'state' AND tracktime=1 ", [pname:entity.processname]]
        m.select = "name";
        m.orderBy = "idx";
        roleStateList = queryService.getList(m)*.name;    
    }

    void afterCreate() {
        entity.required = 1;
        loadAppclassList();
        loadSections();
        loadProcessList();
        entity.appclassid = caller.selectedNode?.title;
    }
    
    void afterOpen() {
        loadSections();
        entity.section = sectionList.find{ it.objid == entity.sectionid };
        loadProcessList();
        appclassList = [ entity.appclassid ];
        stateList = [ entity.activationstate ];
        loadRoleStateList();
    }
    
    //load checklist
    def lookupCheckList() {
        if( entity.checklistid ) {
            return Inv.lookupOpener( "obo_checklist:open", [entity:[objid: entity.checklistid ]] );
        }
        else {
            def s = { o->
                entity.set( "checklistid", o.objid );
                binding.refresh();
            }
            return Inv.lookupOpener("obo_checklist:document:lookup", [onselect: s]); 
        }
    }

    def clearCheckList() {
        entity.set("checklistid", null);
        binding.refresh();    
    }


    def roleListModel = [
        fetchList: { o->
            return entity.customroles;
        },
        isColumnEditable: { item, colname ->
            return ( mode != "read");
        },
        createItem: {
            return [typeid: entity.objid];
        },
        addItem: { o->
            addItem("customroles", o);
        }
    ] as EditorListModel;
    
    void removeRole() {
        if(!MsgBox.confirm("You are about to remove this role. Confirm?")) return;
        if( !selectedItem ) throw new Exception("Please select an item to remove");
        removeItem("customroles", selectedItem );
    }
    
    void beforeSave(def o ) {
        if(!entity.section) entity.sectionid = "{NULL}";
    }
    
}