package com.rameses.gov.etracs.obo.models;

import com.rameses.rcp.annotations.*;
import com.rameses.rcp.common.*;
import com.rameses.osiris2.common.*;
import com.rameses.osiris2.client.*;
import com.rameses.seti2.models.*;
import com.rameses.util.*;
import java.text.*;

public class OboLookupValueModel extends CrudFormModel {

    def listname;
    
    void afterCreate() {
        if(!listname && caller?.selectedNode!=null && caller?.selectedNode?.name ) {
            listname = caller.selectedNode.name;
        }
        entity.listname = listname;
        entity.sortorder = 0;
    }
    
    void afterOpen() {
        edit();
    }
    
    def doOk() {
        boolean cnew = false;
        if( mode=="create") {
            entity.objid = entity.listname + ":" + entity.key;
            cnew = true;
        }
        super.save();
        caller.reloadList();
        if(cnew) {
            listname = entity.listname;
            create();
            return null;
        }
        else {
            return "_close";
        }    
    }
    
    def doCancel() {
        return "_close";
    }

   
    
}