package com.rameses.gov.etracs.obo.models;

import com.rameses.rcp.annotations.*;
import com.rameses.rcp.common.*;
import com.rameses.osiris2.common.*;
import com.rameses.osiris2.client.*;
import com.rameses.seti2.models.*;
import com.rameses.util.*;
import java.text.*;

public class OboLookupValueListModel extends CrudLookupModel {
    
    def _listNames;
    boolean shownodes = true;
    
    public def getNodeList() {
        if(shownodes==false) return null;
        if(_listNames == null) {
            def m = [_schemaname: "obo_lookupvalue"];
            m.select = "listname";
            m.groupBy = "listname";
            m._limit = 1000;
            _listNames = queryService.getList(m).collect{ [name:it.listname, title: it.listname] };
        }
        return _listNames;
    }
    
    public def getCustomFilter() {
        def listname = selectedNode?.name;
        if(!listname) listname = query.listname;
        if(!listname) return null;
        def str = "listname = :listname"
        def param = [listname: listname];
        return [ str, param ];
    }
    
    void reloadList() {
        _listNames = null;
        reload();
    }
    
    public void afterRemoveItem() {
        reloadList();
    }

    public void beforeRemoveItem() {
        if(selectedItem?.system == 1) throw new Exception("This item cannot be deleted");
    }
    
    public boolean isDeleteAllowed() {
        return true;
    }
    
    void initRuleLookup() {
        try {
            def e = caller.caller.caller.entity;
            def listvalue = e.constraints.find{ it.field.name == 'name'  }?.listvalue;
            if(listvalue && listvalue.size()==1) {
                def key =  listvalue[0].key; 
                def m = [_schemaname:"obo_variable"];
                m.findBy = [objid: key];
                m.select = "lookuplistname";
                def lname = queryService.findFirst(m)?.lookuplistname;
                if(lname) {
                    shownodes = false;
                    query.listname = lname;
                }
            }    
            super.init();           
        }
        catch(e) {
            e.printStackTrace();
            throw new Exception("Please check if rule mgmt is updated. " + e.message );
        }
    }
}