package com.rameses.gov.etracs.obo.models;

import com.rameses.rcp.annotations.*
import com.rameses.rcp.common.*
import com.rameses.osiris2.client.*
import com.rameses.osiris2.common.*
import java.rmi.server.*;
import com.rameses.gov.etracs.bpls.application.*;
import com.rameses.util.*;
import com.rameses.osiris2.reports.*;
import com.rameses.seti2.models.*;

public class OboItemAccountModel extends CrudFormModel {
    
    def docTypeList;
    def feeGroupList;


    public void afterInit() {
        def m = [_schemaname: "vw_obo_doctype"];
        m.where = [" version = 0 "];
        m.orderBy = "code";
        docTypeList = queryService.getList(m);
        
        def m1 = [_schemaname: "obo_feegroup"];
        m1.where = ["1=1"];
        m1.orderBy = "sortindex";    
        feeGroupList = queryService.getList(m1);
    }
    
    
    def mapAccount() {
        def s = { o->
            def m = [_schemaname:"obo_itemaccount"];
            m.objid = entity.objid;
            m.item = o;
            persistenceService.update( m );
            reloadEntity();
        }
        return Inv.lookupOpener("itemaccount:lookup", [onselect: s] ); 
    }

    def unmapAccount() {
        def m = [_schemaname:"obo_itemaccount"];
        m.objid = entity.objid;
        m.item = [objid:"{NULL}",code:"{NULL}",title:"{NULL}",fund:[objid:"{NULL}", title:"{NULL}"]];
        persistenceService.update( m );
        reloadEntity();
    }
    
    void beforeSave( def o ) {
        if(o=="update") {
            if( entity.doctypeid == null ) 
                entity.doctype = [objid: "{NULL}"];
            else 
                entity.doctype = [objid: entity.doctypeid ];
                   
            if( entity.feegroupid == null ) 
                entity.feegroup = [objid: "{NULL}"];
            else  
                entity.feegroup = [objid: entity.feegroupid ];   
        }
    }
 
}