package com.rameses.gov.etracs.obo.models;

import com.rameses.rcp.annotations.*;
import com.rameses.rcp.common.*;
import com.rameses.seti2.models.*;
import com.rameses.osiris2.common.*;
import com.rameses.util.*;
import com.rameses.osiris2.common.*;
import com.rameses.rcp.common.*;
import com.rameses.osiris2.client.*;
import com.rameses.enterprise.models.*;

class OboInfoModel  {
    
    @Binding
    def binding;
    
    def items;
    def onselect;
    def formInfos = [];
    
    void init() {
        formInfos.clear();
        items.sort{ it.sortorder }; 
        items.each {x->
            def i = [
                type:x.datatype, 
                caption:x.caption+ ( (x.unit==null) ?'' : ' ('+x.unit+')'), 
                categoryid: x.category,
                name:x.name, 
                bean: x,
                required: true,
                properties: [:],
                value: x.value
            ];
            //fix the datatype
            if(x.datatype.indexOf("_")>0) {
                x.datatype = x.datatype.substring(0, x.datatype.indexOf("_"));
            }
            if(i.type == "boolean") {
                i.type = "yesno";
            }
            else if(i.type == "array") {
                if(x.multiselect == 1) {
                 //multiselect mode    
                    i.expression = "#{item}";
                    i.preferredSize = '0,20';
                    i.editable = false;
                    i.type = "lookup";
                    def s = { o->
                        i.value = o;
                        i.bean.value = o;
                        binding.refresh();
                    }
                    i.handlerObject = Inv.lookupOpener("obo_app_info_listvalue:lookup", [items:x.arrayvalues,onselect:s, values: x.value]);                    
                }
                else {    
                    i.type = "combo";
                    i.preferredSize = '0,20';
                    i.itemsObject = x.arrayvalues;
                }
            }
            else if( i.type == 'decimal' ) {
                i.preferredSize = '150,20';
            }
            else if( i.type == 'integer' ) {
                i.preferredSize = '150,20';
            }
            else if( i.type == 'lookup' ) {
                i.expression = "#{ (item.key == item.title) ? item.key : item.key + '-' + item.title }";                
                def p = [:];
                p.query = ["listname": x.lookuplistname]
                p.shownodes = false;
                i.handlerObject = Inv.lookupOpener("obo_lookupvalue:lookup", p );
                //i.param = []
            }
            else if( i.type == 'text') {
                i.type = "textarea";
                i.preferredSize = '0,60';
            }
            else if( i.type == "string" ) {
                i.type = "text";
            }
            formInfos << i;
        }
        
    }
    
    def formPanel = [
        updateBean: {name,value,item->
            item.bean.value = value;
        },
        getControlList: {
            return formInfos;
        }
    ] as FormPanelModel;
        
    def doOk() {
        onselect( items );
        return "_exit";
    }
    
    def doCancel() {
        return "_exit";
    }
}