package com.rameses.gov.etracs.obo.models;

import com.rameses.rcp.annotations.*;
import com.rameses.rcp.common.*;
import com.rameses.seti2.models.*;
import com.rameses.util.*;
import com.rameses.osiris2.common.*;
import com.rameses.osiris2.client.*;
import java.awt.*;

public class OboImageAttachmentModel  {

	@Service("QueryService")
	def queryService;

	@Service( "SysFileService" )
    def fileSvc;

    def file;
    def selectedItem;
    def fileitems;

    boolean canEdit = true;
    
    void loadItems() {
    	def r = [_schemaname: "sys_fileitem"];
        r.findBy = [parentid: file.objid ];
        fileitems = queryService.getList( r ).collect {
       		[ objid: it.objid, image: it.thumbnail  ] 	
        }; 
    }

    def getImage() {
        def upd = new FileDownloader( selectedItem );
        upd.connection = "obo";
        def item = upd.open(); 
        return upd.createURL(); 
    }

    void init() {
    	loadItems();
    	selectedItem = fileitems[0];
    }

    def doClose() {
        return "_close";
    }

    def imageListHandler = [
	    fetchList: {
	    	return fileitems;    
	    } 
	] as ImageGalleryModel;


	def addImage() {
		def s = { o->
			loadItems();	
       		imageListHandler.reload(); 	    
        }
        return Inv.lookupOpener( "obo_app_attachment:addItem", [ entity: file, saveHandler: s ] );
    }

	def removeImage() {
		if(!selectedItem) throw new Exception("Please select an item");
		fileSvc.remove( [item: [objid: selectedItem.objid ]] );
        def ri = fileitems.find{ it.objid == selectedItem.objid };
        fileitems.remove( ri );
        imageListHandler.reload(); 
    }


}


