package com.rameses.gov.etracs.obo.models;

import com.rameses.rcp.annotations.*;
import com.rameses.rcp.common.*;
import com.rameses.seti2.models.*;
import com.rameses.osiris2.common.*;
import com.rameses.util.*;
import com.rameses.osiris2.common.*;
import com.rameses.rcp.common.*;
import com.rameses.osiris2.client.*;
import com.rameses.enterprise.models.*;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileNameExtensionFilter;


class OboFindingTypeModel extends CrudFormModel {

    def sectionid;
    def sectionList;    

    def listHandler;

    @PropertyChangeListener
    def listener = [
        sectionid: { o->
            listHandler.reload();
        }
    ];

    def getQuery() {
        def str = "typeid = :id";
        def p = [id: entity.objid];
        if(sectionid == null ) {
            str += " AND sectionid IS NULL ";    
        }
        else {
            str += " AND sectionid = :sectionid";
            p.sectionid = sectionid;
        }
        return [
            where : [ str, p]
        ];
    }

    void afterInit() {
        if( entity.requiresection == 1) {
            def m = [_schemaname: "obo_section"];
            m.where = "1=1";
            sectionList = queryService.getList( m );            
        } 
    }

    def addDoctype() {
        def p = [
            onselect: { o->
                def m = [_schemaname: "obo_finding_type" ];
                m.findBy = [objid: entity.objid ];
                m.doctypeid = o.objid;
                persistenceService.update( m );
                entity.doctypeid = o.objid;
                binding.refresh();
            }
        ];
        return Inv.lookupOpener( "obo_doctype:report:lookup", p );     
    }

    def lookupReportDef() {
        def s = { o->
            entity.set( "reportid", o.name );
            binding.refresh();
        }
        return Inv.lookupOpener("sys_report_def:lookup", [onselect: s]);    
    }
    
}