package com.rameses.gov.etracs.obo.models;

import com.rameses.rcp.annotations.*;
import com.rameses.rcp.common.*;
import com.rameses.seti2.models.*;
import com.rameses.util.*;
import com.rameses.osiris2.common.*;
import com.rameses.osiris2.client.*;
import obo.util.*;

/**
* Notes on who can edit findings:
* 
*
* finding status:
*    1 = closed
*    2 = open
*/  
abstract class OboFindingListModel extends AppFormSectionListModel {

    @Service("OboAppFindingService")
    def findingSvc;

    def viewState = 2;
    def findingItems;

    def sectionList;
    def selectedSection;

    def findingType;

    def ch = new CheckListUtil();

    public abstract boolean isShowSections();
    public abstract void init();

    @PropertyChangeListener
    def listener = [
        "viewState" : { o->
            refresh();
        },
        "selectedSection" : { o->
            refresh();    
        }
    ];

    String getFindingtype() {
        return invoker.properties.findingtype;
    }

    String getEditState() {
        return invoker.properties.editState;
    }

    boolean getCanEdit() {
        boolean retval = false;
        if( formContext == "application" ) {
            if( editState && appState.matches( editState ) ) {
                if( hasRole("COORDINATOR") ) {
                    retval = true;
                }
                else if( isTaskAssignee() ) {
                    retval = true;
                }
            }    
        }
        else if( formContext == "taskitem" ) {
            retval = isTaskAssignee();
        }
        return retval;
    } 

    boolean getEditable() {
        return true;
    }

    void loadItems() {
        def r = [appid: appid];
        if( editState != 'post-requirement') {
            r.findingtypeid = findingtype;
            if( viewState > 0) {
                r.state = viewState;
            }
            if(selectedSection) r.sectionid = selectedSection.sectionid;
            findingItems = findingSvc.getList( r );            
        }
        else {
            findingItems = findingSvc.getOpenPostRequirementList( r );     
        }
    }

    def fetchList( def o ) {
        if(!findingItems) loadItems();
        return findingItems;    
    }

    void refresh() {
        findingItems = null;
        super.refresh();
    }

    boolean isOwnerEditor() {
        return selectedItem.createdby?.objid == userid;
    }

    def viewItem(def sitem) {
        def r = findingSvc.openItem( [objid: sitem.objid ] );
        def p = [entity:r];
        if( ownerEditor ) {
            p.editable = (!sitem.transmittalid) ? true : false ;
            p.saveHandler = { e->
                def m = [_schemaname: "obo_app_finding"];
                e.appid = appid;
                m.putAll( e );
                persistenceService.update( m );            
                refresh();
            }
        }
        return Inv.lookupOpener("obo_app_finding:open", p );
    }

    //saves the new item;
    def saveNewItem = {e ->
         def m = [_schemaname: "obo_app_finding"];
         m.putAll( e );
         m.appid = appid;
         persistenceService.create( m );            
         refresh();
    }

    def addItem() {
        def p = [ typeid: findingtype, appid: appid ];
        if( entity.sectionid ) {
            p.taskitemid = entity.objid;
        }

        if( entity.sectionid ) {
            p.sectionid = entity.sectionid;    
        }
        else if( !selectedSection ) {
            if(sectionList) throw new Exception("Please select a section");        
        }
        else {
            p.sectionid = selectedSection.sectionid;
        }
        
        p.saveHandler = saveNewItem;
        return Inv.lookupOpener("obo_app_finding:create", p );
    }

    void validateSection() {
        if(!sectionList) return;
        if(selectedSection) {
            if(!isSameOrg( selectedSection.section.org?.objid ))
                throw new Exception("You cannot add section that does not belong to your org");
        }    
    }

    void removeItem(def sitem) {
        if(!ownerEditor) throw new Exception("Only editor of the entry can remove this item. Use supersede instead");
        if(sitem.transmittalid) throw new Exception("Cannot remove an item that has already been transmitted");
        validateSection();
        def m = [_schemaname: "obo_app_finding"];
        m.findBy = [objid: sitem.objid ];
        persistenceService.removeEntity( m );
    }

    def supersedeItem() {
        if(!selectedItem) throw new Exception("Please select an item");
        if(ownerEditor && !selectedItem.transmittalid) 
            throw new Exception("You are editor of this entry. Use view item instead");
        validateSection();    

        def p = [superseded: selectedItem];
        p.saveHandler = saveNewItem;
        return Inv.lookupOpener("obo_app_finding:supersede", p );
    } 
    
    boolean isVisible() {
        return false;
    }

    def viewTransmittal() {
        if( !selectedItem.transmittalid ) 
            throw new Exception("This item has not yet been transmitted");
        if( !findingType ) {
            def m = [_schemaname:"obo_finding_type"];
            m.findBy = [objid: findingtype];
            findingType = queryService.findFirst( m );
        }    

        def  p = [:];
        p.reportid = findingType.reportid;
        p.query = [objid: selectedItem.transmittalid ];
        p.connection = "obo";
        def op = Inv.lookupOpener( "sys_report_form", p );
        op.target = "popup";
        return op;
    }



}


