package com.rameses.gov.etracs.obo.models;

import com.rameses.rcp.annotations.*;
import com.rameses.rcp.common.*;
import com.rameses.seti2.models.*;
import com.rameses.osiris2.common.*;
import com.rameses.util.*;
import com.rameses.osiris2.common.*;
import com.rameses.rcp.common.*;
import com.rameses.osiris2.client.*;
import com.rameses.enterprise.models.*;
import com.rameses.menu.models.*;

class OboFXMenuCategoryModel  extends FXMenuCategoryModel {

    @Service("OboMenuService")
    def menuSvc;

    @Service("SysReportService")
    def reportSvc;
    
    def buildInvokers = { list, subitems, invokers, category ->
        int i = 100;
        list.each {
            try {
                if(!it.handler) return;
                def title = it.handler;
                def id = title + "/" + it.objid;
                def notid = (title + ":" + it.objid.toLowerCase()).trim();
                def subitem = [ id: id, caption: it.title, index: (i++), notificationid: notid, event: title ];
                subitems << subitem;
                def sinv = title + ":listhandler";
                def stitle = it.title;
                if( category ) stitle = it.title + " (" + category + ")";
                def op = Inv.lookupOpener(sinv, [typeid: it.objid, 'title': stitle, processname: it.processname ]);
                op.domain = "OBO";
                op.target = 'window';
                op.id = sinv;
                invokers.put( id, op );
                subitem.modulename = "obo";
                subitem.domain = op.domain;
                subitem.connection = "obo";      
            }
            catch(e) {
                //println e.message;
            }
        }
    }
    
    def taskitemMenu;
    
    def addReportInvoker = { o, subitems, invokers->
        def id = "sys_report:obo:"+o.name;
        def subitem = [id:id, caption:o.title, index:o.sortindex];
        subitems << subitem;
        
        def invokerMap = [:];
        invokerMap.params = [
            reportDef:  o,
            title: o.title,
            connection: "obo",
        ];
        invokerMap.handler = { p->
            def op = Inv.lookupOpener("sys_report_form", p);
            op.domain = "OBO";
            op.target = 'window';
            op.id = id;
            return op;
        }
        invokers.put( id, invokerMap );
    }

    void loadDynamicItems( String _id, def subitems, def invokers ) {
        if(!taskitemMenu) {
            taskitemMenu = menuSvc.getTaskitemMenu();
            taskitemMenu.each {
                it.handler = "obo_app_taskitem";
            }
        }
        
        if(_id == 'building_taskitem' ) {
            def list = taskitemMenu.findAll{ it.appclassid.toLowerCase() == 'building_permit' };
            buildInvokers( list, subitems, invokers, "Building Permit" );
        }
        else if(_id == 'occupancy_taskitem' ) {
            def list = taskitemMenu.findAll{ it.appclassid.toLowerCase() == 'occupancy_certificate' };
            buildInvokers( list, subitems, invokers, "Occupancy Certificate" );
        }        
        else if( _id == 'obo_doctype' ) {
            def list = menuSvc.getDocumentsForIssuance();
            list.each {
		      it.handler ="obo_app_doc";
            }
            buildInvokers( list, subitems, invokers, null );
        }
        else if( _id == "reports" ) {
            def list = reportSvc.getListByCategory([ category: "reports" ] );
            list.each {
                addReportInvoker( it, subitems, invokers );    
            }
        }
        else if( _id == "obo_control") {
            def list = menuSvc.getOboControlList();
            list.each {
                it.handler = "obo_control";   
            }
            buildInvokers( list, subitems, invokers, null );
        }
    }
    
}