package com.rameses.gov.etracs.obo.models;

import com.rameses.rcp.annotations.*;
import com.rameses.rcp.common.*;
import com.rameses.puti2.models.*;
import com.rameses.osiris2.common.*;
import com.rameses.util.*;
import com.rameses.rcp.common.*;
import com.rameses.osiris2.client.*;
import com.rameses.enterprise.models.*;
import com.rameses.gov.etracs.obo.models.*;
import com.rameses.seti2.models.*;

class OboDocTypeModel extends CrudFormModel {
    
    @Service("LOVService")
    def LOV;

    def docTypes; 
    def appTypes;
    def sectionList;
    
    def requirefee = 0;
    def query = [:];
    def itemHandler;

    @PropertyChangeListener
    def listener = [
        "entity.type" : { o->
            if(!o?.toString().toLowerCase().equals("checklist")) {
                entity.subtypeof = null;
            }
        },
        "requirefee" : { o->
            if( requirefee == 0) {
                entity.requirefee = 0;
            }
            else {
                entity.requirefee = 1;
            }
        }
    ];
    
    def _subTypes;
    public def getSubTypes() {
        if(_subTypes) return _subTypes;
        def m = [_schemaname: schemaName];
        m.where = ["type = 'MAIN' "];
        _subTypes = queryService.getList(m)*.objid;
        return _subTypes;
    }
    
    public void afterInit() {
        def m = [_schemaname: "obo_section"];
        m.where = ["1=1"];
        sectionList = queryService.getList(m);

        docTypes = LOV.get("OBO_DOCTYPE_TYPE")*.key;

        /*
        def m1 = [_schemaname: "obo_appclass"];
        m1.where = ["1=1"];
        m1.select = "objid";
        appTypes = queryService.getList(m1)*.objid;
        */
    }
    
    public void afterOpen() {
        requirefee = (entity.requirefee !=0 ) ? 1: 0;
        query = [code: entity.code ];
    }

    public void afterCreate() {
        entity.version = 0;
        query = [code: entity.code ];
    }

    void supersede() {
        def oldEntity = entity;
        int newver = (oldEntity.version == null) ? 1 : oldEntity.version + 1;
        create();
        entity.putAll( oldEntity );
        entity.remove("objid");
        entity.version = newver;
        entity.supersededid = oldEntity.objid;
    } 
    
    void beforeSave( def s ) {
        if( s == "create") {
            entity.objid = entity.code + (( !entity.version ) ? "" : ":"+entity.version );    
        }
    }

    def lookupHeader() {
        def s = { o->
            MsgBox.alert("selected "+o);
        }
        return Inv.lookupOpener("sys_report_header:lookup", [onselect: s]);
    }

    def lookupReport() {
        def s = { o->
            entity.put( "reportid", o.name );
            binding.refresh();
        }
        return Inv.lookupOpener("sys_report_def:lookup", [onselect: s]);    
    }

    def clearReport() {
        entity.put("reportid", null);
        binding.refresh();    
    }

    def lookupReportTemplate() {
        def s = { o->
            entity.put("template",o.name);
            binding.refresh();
        }
        return Inv.lookupOpener("sys_report_template:lookup", [onselect: s]);    
    }

    def clearReportTemplate() {
        entity.put("template", null);
        binding.refresh();    
    }


    def lookupCheckList() {
        if( entity.checklistid ) {
            return Inv.lookupOpener( "obo_checklist:open", [entity:[objid: entity.checklistid ]] );
        }
        else {
            def s = { o->
                entity.put( "checklistid", o.objid );
                binding.refresh();
            }
            return Inv.lookupOpener("obo_checklist:document:lookup", [onselect: s]); 
        }
    }

    def clearCheckList() {
        entity.put("checklistid", null);
        binding.refresh();    
    }


    def clearRefDoc() {
        entity.put("refdoc", null);
        binding.refresh();    
    }

    def lookupRefDoc() {
        def s = { o->
            entity.put("refdoc", o.code);
            binding.refresh();
        }
        return Inv.lookupOpener("obo_doctype:refdoc:lookup", [onselect: s]);    
    }
    
    //HEADERS
    def lookupReportHeader() {
        def s = { o->
            entity.put("reportheader",o.name);
            binding.refresh();
        }
        return Inv.lookupOpener("sys_report_header:lookup", [onselect: s]);    
    }

    def clearReportHeader() {
        entity.put("reportheader", null);
        binding.refresh();    
    }

    
}