package com.rameses.gov.etracs.obo.models;

import com.rameses.rcp.annotations.*;
import com.rameses.rcp.common.*;
import com.rameses.seti2.models.*;
import com.rameses.util.*;
import com.rameses.osiris2.common.*;
import com.rameses.osiris2.client.*;
import obo.util.*;
import com.rameses.rcp.framework.ClientContext;

class OboControlGenerateModel  {

    @Service("QueryService")
    def qrySvc;
    
    @Service("OboControlService")
    def controlSvc;

    def docTypeList; 
    
    def handler;
    
    def typeid;
    def pattern;
    def startno;
    def endno;
    
    public boolean isOrgroot() {
        return (OsirisContext.env.ORGROOT == 1 );
    }
    
    public String getOrgid() {
        return OsirisContext.getEnv().ORGID;
    }
    
    void init() {
        startno = 0;
        endno = 0;
        pattern = "[yyyy]-[%05d]";
    }
    
    def doOk() {
        if(!MsgBox.confirm("You are about to generate the set of control numbers. Proceed?")) return;
        def m = [doctypeid: typeid, pattern: pattern, startno: startno, endno: endno ];
        controlSvc.generate( m );
        handler();
        return "_close";
    }
    
    def doCancel() {
        return "_close";
    } 

    void previewSample() {
        def m = [pattern: pattern, sampleno: startno ];
        def r = controlSvc.formatNumber( m );
        MsgBox.alert( r );
    }
    
}
