package com.rameses.gov.etracs.obo.models;

import com.rameses.rcp.annotations.*;
import com.rameses.rcp.common.*;
import com.rameses.seti2.models.*;
import com.rameses.osiris2.common.*;
import com.rameses.util.*;
import com.rameses.osiris2.common.*;
import com.rameses.rcp.common.*;
import com.rameses.osiris2.client.*;
import com.rameses.enterprise.models.*;
import javax.swing.*;
import com.rameses.io.*;
import com.rameses.gov.etracs.obo.models.*;
import obo.util.*;

class OboChecklistEditorModel  {

    def entity;
    def handler;
    def bean = [:];
    def template;
    
    def formControls = [];
    
    def formPanel = [
        getControlList: {
            return formControls;
        }
    ] as FormPanelModel;
    
    void init() {
        def cl = new CheckListEditor();
        def r = cl.parse( entity.template, entity.values );
        template = r.template;
        formControls = [];
        def values = r.values;
        int i = 0;
        r.params?.each {
            def fldname = "t"+i;
            if( values !=null ) {
                bean.put(fldname, values[i] );
            }
            def v = [:];
            v.caption = ""+ i;
            if(it=="n") v.type = "decimal";
            else if(it=="i") v.type = "integer";           
            else if(it=="d") v.type = "date";
            else if(it=="b") {
                v.type = "checkbox";
                v.checkValue = 1;
                v.uncheckValue = 0;
            }    
            else {
                v.type = "text";
                v.textCase = "NONE";
            }
            v.name = "bean."+fldname;
            formControls << v;
            i = i+1;
        }
    }
    
    def doOk() {
        def list = bean.collect{ [id:it.key, val:it.value]  };
        def z = list.collect{ it.val };
        handler([objid:entity.objid, values:z] );
        return "_close";
    }
    
    def doCancel() {
        return "_close";
    }
    
}