package com.rameses.gov.etracs.obo.models;

import com.rameses.rcp.annotations.*;
import com.rameses.rcp.common.*;
import com.rameses.seti2.models.*;
import com.rameses.util.*;
import com.rameses.osiris2.common.*;
import com.rameses.osiris2.client.*;

public class OboBillModel {

    @Service("OboBillingService")
    def billingSvc;

    @Service("QueryService")
    def querySvc;

	@Caller
	def caller;

	@Binding
	def binding;

    def bill;
    def payment;

    def getAppTaskstate() {
        return caller.task.state;
    }

    boolean isUserTaskAssignee() {
        return caller.isUserTaskAssignee();
    }

    void create() {
        if(!MsgBox.confirm("You are about to create a new bill. Proceed?"))
            throw new BreakException();
        def m = [appid: caller.entity.objid, appno: caller.entity.appno ];
        bill = billingSvc.createBill( m );
        caller.entity.bill = bill;
        caller.entity.billid = bill.objid;
        caller.binding.refresh();
        open();
    }

    void open() {
        if(!bill) {
            bill = caller.entity.bill;
            bill.objid = caller.entity.billid;
            bill.appid = caller.entity.objid;
        }

        //retrieve payment
        def m = [_schemaname: "obo_payment"];
        m.findBy = [appid: bill.appid];
        m.where = ["voided = 0"];
        payment = querySvc.findFirst( m );
        if(payment) {
            payment.txnmode = (payment.refid == null) ? "CAPTURED" : "ONLINE";
        }
    }

    def cancelBill() {
        if(!MsgBox.confirm("You are about to cancel this bill. Proceed?")) return null;
        billingSvc.cancelBill( [billid: bill.objid ] );
        caller.entity.billid =null;
        caller.entity.bill = null;
        caller.binding.refresh();
        return "_close";
    }

    def previewBill() {
        def p = [:];
        p.reportid = "obo_bill";
        p.query = [objid: bill.objid ];
        p.connection = "obo";
        p.defaultEmail = caller.entity.contact?.email;
        return Inv.lookupOpener( "sys_report_form", p );
    }

    def listHandler = [
        fetchList: { o->
            def m = [_schemaname: "obo_app_fee"];
            m.findBy = [appid: bill.appid ];
            m.orderBy = "item.sortorder"
            return querySvc.getList( m );
        }
    ] as BasicListModel;

    
    def capturePayment() { 
        def p = [entity:bill];
        p.saveHandler = { o->
            caller.reloadEntity();
            binding.refresh();
        }
        return Inv.lookupOpener("obo_app_payment:capture", p);
    }

}


