package com.rameses.gov.etracs.obo.models;

import com.rameses.rcp.annotations.*;
import com.rameses.rcp.common.*;
import com.rameses.seti2.models.*;
import com.rameses.osiris2.common.*;
import com.rameses.util.*;
import com.rameses.rcp.common.*;
import com.rameses.osiris2.client.*;
import com.rameses.enterprise.models.*;
import com.rameses.gov.etracs.obo.models.*;

class OboApplicationInitialModel  {

    @Invoker
    def invoker;

    @Service("OboAppCloudInitialService")
    def downloadSvc;
    
    @Service("OboAppService")
    def appSvc;
    
    @Service("QueryService")
    def querySvc;
    
    def trackingno;
    def txnmode = "CAPTURE";
    def txnModes = ["ONLINE", "CAPTURE"];
    def source = "web";
    def taskStates;
    def taskstate;
    

    @FormTitle
    public String getTitle() {
        return "New Application (" + invoker.properties.title + ")";
    }
    
    public String getAppclass() {
        return invoker.properties.appclass;
    }
    
    void init() {
        def m = [_schemaname: "sys_wf_node"];
        m.select = "name";
        m.where = [ "processname = :procname AND name NOT IN ('start','end') AND tracktime=1", [procname: getAppclass() ]  ];
        m.orderBy = "idx";
        taskStates = querySvc.getList( m )*.name + ["end"];
    }
    
    def next() {
        if(source==null) source = "web";
        
        if(source.matches("web|local")) {
            def v = downloadSvc.getApplication( [trackingno: trackingno, appclass: getAppclass() ]  );
            if(!MsgBox.confirm("You are about to transfer online data to the system. Proceed?")) {
                return null;
            };
            v.txnmode = "ONLINE";
            v.appclass = getAppclass();
            v = appSvc.create( v );
            def entity = [objid: v.objid ];            
            def op = Inv.lookupOpener("vw_" + getAppclass() + ":open", [entity:entity] );  
            op.target = "self";
            return op;
        }
        else if( source == "capture") {
            def p = [txnmode: txnmode ];
            p.taskstate = taskstate;
            return Inv.lookupOpener( getAppclass() + ":create", p );
        }
        else {
            throw new Exception("File option not yet accepted!");
        }
    }
    
}