package com.rameses.gov.etracs.obo.models;

import com.rameses.rcp.annotations.*;
import com.rameses.rcp.common.*;
import com.rameses.seti2.models.*;
import com.rameses.osiris2.common.*;
import com.rameses.util.*;
import com.rameses.osiris2.common.*;
import com.rameses.rcp.common.*;
import com.rameses.osiris2.client.*;
import com.rameses.enterprise.models.*;
import com.rameses.gov.etracs.obo.models.*;

class OboAppTaskitemModel extends WorkflowTaskModel implements IFormContext {

    //-- IFormContext implementation
    public String getFormContext() {
        return "taskitem";    
    }

    public String getAppid() {
        return entity.appid;
    }

    public String getAppno() {
        return entity.app.appno;
    }

    public String getAppType() {
        return entity.app.processname;
    }

    public String getAppState() {
        return entity.app.task.state;       
    }

    public String getAppClassid() {
        return entity.app.appclassid;
    }
    //-- IFormContext implementation

    //sectionid 
    public String getSectionid() {
        return entity.sectionid;
    }

    public def getSection() {
        return entity.type.section;
    }

    public def getOrgid() {
        return section?.org?.objid;    
    }

    @FormTitle
    public String getTitle() {
        return entity.app.appno + " " + entity.type.title + " (" + entity.task?.title + ")"; 
    }
    
    public String getFormId() {
        return entity.objid;
    }
    
    public String getNotificationid() {
        return "obo_app_taskitem:" + entity.typeid.toLowerCase();
    }
    
    public def getSections() {
        def list =  Inv.lookupOpeners("obo_app_taskitem:sections", [caller:this] );        
        def customList = Inv.lookupOpeners(entity.app.processname.trim().toLowerCase() + ":taskitem:sections", [caller:this] );
        return (list + customList ).sort{ it.properties.index }; 
    }
    
    public String getProcessName() {
        return entity.task.processname;
    }
    
    public String getSchemaName(){
        return "vw_obo_app_taskitem" ;
    }    
    
    public String getEntitySchemaName() {
        return "obo_app_taskitem";
    }    
    
    //we must send the typeid so we can evaluate 
    public boolean beforeSignal( def param  ) {
        param.typeid = entity.typeid;
        return true;
    }

    public def viewApplication() {
        def op = Inv.lookupOpener(appType + ":open", [entity: [objid: entity.appid]]);
        op.target = "self";
        return op;
    }
    
    public boolean getAllowShowApplication() {
        if(caller instanceof AppFormSectionListModel) {
            return false;
        }
        else {
            return true;
        }
    }
    
}