package com.rameses.gov.etracs.obo.models;

import com.rameses.rcp.annotations.*;
import com.rameses.rcp.common.*;
import com.rameses.seti2.models.*;
import com.rameses.util.*;
import com.rameses.osiris2.common.*;
import com.rameses.osiris2.client.*;

public class OboAppTaskitemListModel extends AppFormSectionListModel  {

    @Service("OboAppTaskitemService")
    def taskItemSvc;

    def viewType = "all";
    
    public String getEditState() {
        return invoker.properties.editState;
    }

    public boolean getCanEdit() {
        if( editState && appState.matches(editState) ) {
            if( task.tracktime != 1 ) return false;
            return isTaskAssignee();        
        }
        else {
            return false;
        }
    }
    
    @PropertyChangeListener
    def listener = [
        "viewType": {
            listHandler.reload();
        }
    ];
    
    public def fetchList( def o ) {
        return taskItemSvc.getList( [appid: entity.objid, viewtype: viewType ] );    
    }

    def viewItem(def sitem) {
        return Inv.lookupOpener("obo_app_taskitem:open", [entity:sitem]);
    }

    def addItem() {
        def h = [:];
        h.query = [ appclassid: appClassid ];
        h.onselect = { o->
            taskItemSvc.create( [appid: entity.objid, typeid: o.objid ] );
            refresh();
        }
        return Inv.lookupOpener( "obo_taskitem_type:lookup" , h );
    }
    
    def supersedeTask() {
        if(!selectedItem) throw new Exception("Please select an task to supersede");
        if( !MsgBox.confirm("You are about to reactivate this task. Proceed?")) return;
        taskItemSvc.supersede( [prevtaskid: selectedItem.objid ] );
        refresh();
    }

    public boolean validateBeforeRemove() {
        if( selectedItem.task.assignee?.objid ) {
            return MsgBox.confirm("This task has already been started by " + selectedItem.task.assignee?.name + ". Continue?" );        
        }
        else {
            return super.validateBeforeRemove();    
        }    
    }

    void removeItem(def sitem) {
        taskItemSvc.removeTaskitem( [objid: sitem.objid ] );
    }
   
    def reactivate() {
        if(!selectedItem?.objid ) throw new Exception("Please select an item first");
        if( selectedItem.task.state != 'end') throw new Exception("Only ended tasks can be reactivated");
        taskItemSvc.reactivate( selectedItem );
        refresh();        
    }
    
}


