package com.rameses.gov.etracs.obo.models;

import com.rameses.rcp.annotations.*;
import com.rameses.rcp.common.*;
import com.rameses.seti2.models.*;
import com.rameses.osiris2.common.*;
import com.rameses.util.*;
import com.rameses.osiris2.common.*;
import com.rameses.rcp.common.*;
import com.rameses.osiris2.client.*;
import com.rameses.enterprise.models.*;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileNameExtensionFilter;
import obo.util.*;

public class OboAppReqFindingModel {

    @Binding
    def binding;

    def entity;
    def saveHandler;
    def subject;

    def superseded;

    boolean editable;
    def mode;
    def checklistid;

    def subform;

    def lookupChecklist() {
        def p = [:];
        p.query = [checklistid: checklistid];
        p.onselect = { c->
            entity.checklistitem = c;
            entity.checklistitemid = c.objid;
            subject = entity.checklistitem.title; 
            if( subject == "{s}" ) subject = null;
            binding.fireNavigation("default");
        };
        p.oncancel = {
            binding.fireNavigation("_close");
        }   
        return Inv.lookupOpener( "obo_checklist_item:lookup", p );
    }

    def create() {
        editable = true;
        entity = [:];
        entity.state = 2;
        mode = "create";
        subform = lookupChecklist();
        return "select-item";
    }

    void open() {
        subject = entity.checklistitem.title; 
        if( subject == "{s}" ) subject = null;
        mode = "open";
    }

    void supersede() {
        editable = true;
        entity = [:];
        entity.checklistitem = superseded.checklistitem;
        entity.checklistitemid = superseded.checklistitemid;
        entity.supersededid = superseded.objid;
        entity.values = superseded.values;
        entity.particulars = superseded.particulars;
        entity.state = 1;  
    }

    def doOk() {
        if(editable) {
            saveHandler( entity );
        }
        return "_close";
    }

    def doCancel() {
        return "_close";
    }

    


}