package com.rameses.gov.etracs.obo.models;

import com.rameses.rcp.annotations.*;
import com.rameses.rcp.common.*;
import com.rameses.seti2.models.*;
import com.rameses.util.*;
import com.rameses.osiris2.common.*;
import com.rameses.osiris2.client.*;
import obo.util.*;

/**
* Notes on who can edit findings:
* 
*
* finding status:
*    1 = closed
*    2 = open
*/  
class OboAppReqFindingListModel extends AppFormSectionListModel {

    @Service("OboAppTransmittalService")
    def transmittalSvc;

    def viewState = 2;
    def checklistid;

    @PropertyChangeListener
    def listener = [
        "viewState" : { o->
            refresh();
        }
    ];

    String getEditState() {
        return invoker.properties.editState;
    }

    boolean isOwnerEditor() {
        return selectedItem.createdby?.objid == userid;
    }

    boolean getCanEdit() {
        boolean retval = false;
        if( editState && appState.matches( editState ) ) {
            if( task.tracktime != 1 ) return false;
            retval = isTaskAssignee();
        }    
        return retval;
    } 

    def saveNewItem = {e ->
         def m = [_schemaname: "obo_app_req_finding"];
         m.putAll( e );
         m.appid = appid;
         persistenceService.create( m );            
         refresh();
    }    

    def addItem() {
        if( checklistid == null ) {
            def m = [_schemaname: "obo_appclass"];
            m.findBy = [objid: appClassid ];
            def c = queryService.findFirst( m );
            if(!c.reqnod?.checklistid) throw new Exception("Please specify req nod doctype in "  + appClassid );
            checklistid = c.reqnod?.checklistid;
        }
        def p = [:];
        p.saveHandler = saveNewItem;
        p.checklistid = checklistid;
        return Inv.lookupOpener("obo_app_req_finding:create", p );
    }

    void removeItem(def sitem) {
        if(!ownerEditor) throw new Exception("Only editor of the entry can remove this item. Use supersede instead");
        if(sitem.transmittalid) throw new Exception("Cannot remove an item that has already been transmitted");
        def m = [_schemaname: "obo_app_req_finding"];
        m.findBy = [objid: sitem.objid ];
        persistenceService.removeEntity( m );
    }

    def supersedeItem() {
        if(!selectedItem) throw new Exception("Please select an item");
        if(ownerEditor && !selectedItem.transmittalid) 
            throw new Exception("You are editor of this entry. Use view item instead");
        def p = [superseded: selectedItem];
        p.saveHandler = saveNewItem;
        return Inv.lookupOpener("obo_app_req_finding:supersede", p );
    } 

    def viewItem(def sitem) {
        def m = [_schemaname: "vw_obo_app_req_finding"];
        m.findBy = [objid: sitem.objid];
        def r = queryService.findFirst( m );
        def p = [entity:r];
        if( ownerEditor ) {
            p.editable = (!sitem.transmittalid) ? true : false ;
            p.saveHandler = { e->
                def m1 = [_schemaname: "obo_app_req_finding"];
                e.appid = appid;
                m1.putAll( e );
                persistenceService.update( m1 );            
                refresh();
            }
        }
        return Inv.lookupOpener("obo_app_req_finding:open", p );
    }

    def fetchList( def o ) {
        CheckListUtil ch = new CheckListUtil();
        def m = [_schemaname: "vw_obo_app_req_finding"];  
        m.findBy = [appid: appid ];
        def arr = [];
        def p = [:];

        arr << "superseded = 0";        
        if( viewState > 0 ) {
            arr << " state = :state ";
            p.state = viewState; 
        } 
        m.where = [arr.join( " AND "), p];
        def list = queryService.getList( m );
        ch.formatList( list );
        return list;
    }

    def viewTransmittal() {
        if( !selectedItem.transmittalid ) 
            throw new Exception("This item has not yet been transmitted");
        def m = [_schemaname: "obo_app_transmittal"];
        m.findBy = [objid: selectedItem.transmittalid ];
        def t = queryService.findFirst( m );    

        def  p = [:];
        p.reportid = t.doctype.reportid;
        p.query = [objid: t.objid ];
        p.connection = "obo";
        def op = Inv.lookupOpener( "sys_report_form", p );
        op.target = "popup";
        return op;
    }

}


