package com.rameses.gov.etracs.obo.models;

import com.rameses.rcp.annotations.*;
import com.rameses.rcp.common.*;
import com.rameses.seti2.models.*;
import com.rameses.osiris2.common.*;
import com.rameses.util.*;
import com.rameses.osiris2.common.*;
import com.rameses.rcp.common.*;
import com.rameses.osiris2.client.*;
import com.rameses.enterprise.models.*;
import javax.swing.JFileChooser;


class OboAppProfessionalListModel extends AppFormSectionListModel  {

    String schemaName= "obo_app_professional";
    
    String getEditState() {
        return invoker.properties.editState;
    }

    boolean getCanEdit() {
        if( formContext == "application" ) {
            if( task.tracktime != 1 ) return false;
            if( editState && appState.matches( editState ) ) {
                return isTaskAssignee();
            }
            else {
                return hasRole( "COORDINATOR" );
            }    
        }
        else if( formContext == "taskitem" ) {
            return isTaskAssignee();
        }
        return false;
    } 
    
    void init() {
        
    }

    def viewItem(def sitem) {
        def p = [:];
        p.entity = sitem;
        def op = Inv.lookupOpener(schemaName + ":open", p );
        op.target = "popup";
        return op;
    }
    
    def formatProf( def o ) {
        if(!o.objid) return "";
        return o.lastname + "," + o.firstname + "(" + o.profession + "-" + o.prc.idno + ")";
    }
    
    def fetchList(def o) {
        def m = [_schemaname: schemaName];
        m.findBy = [appid: appid ];
        def flist =  queryService.getList( m );
        return flist.collect{
            [ 
                objid: it.objid,    
                sectioninfo : (it.section?.title !=null) ? it.section.title : it.doctype,
                designprofessionalinfo: formatProf(it.designprofessional),
                supervisorinfo : formatProf(it.supervisor)
            ]
        }    
    }

    def addItem() {
        def section = null;
        def h = [:]
        h.onselect = { o->
            section = o;
        }
        h.listHandler = [
            fetchList: {
                def m = [_schemaname:"obo_section"];
                m.where = ["org.objid IS NULL"];
                return queryService.getList(m);
            },
            getColumns: {
                return [
                    [name:"objid", caption:"Section"],
                ];
            }
        ] as BasicListModel;
        h.title = "Please select a section";
        Modal.show( "simple_list_lookup" , h );
        if(!section)return;
        Modal.show("obo_app_professional:create", [section: section, appid: entity.objid ] );
        refresh();
    }
    
    void removeItem(def sitem) {
        def m = [_schemaname: "obo_app_professional"];
        m.objid = sitem.objid;
        persistenceService.removeEntity(m);
    }
    

}