package com.rameses.gov.etracs.obo.models;

import com.rameses.rcp.annotations.*;
import com.rameses.rcp.common.*;
import com.rameses.seti2.models.*;
import com.rameses.util.*;
import com.rameses.osiris2.common.*;
import com.rameses.osiris2.client.*;

public class OboAppListModel extends WorkflowTaskListModel  {

    @Service("OboAppService")
    def oboAppSvc;
  
    def open() {
        if(!selectedItem) throw new Exception("Please select an item"); 
        def appclassid = invoker.properties.appclass;   
    	def op = Inv.lookupOpener( appclassid+":open", [ entity:selectedItem] );
        op.target = "window";
        return op;
    }

    def create() {
        def appclassid = invoker.properties.appclass;
        def op = Inv.lookupOpener( appclassid+":initial", [:] );
        op.target = "window";
        return op;
    }
   
    public String getEntitySchemaName() {
        return "obo_app";        
    }

    void removeEntity() {
        if(!selectedItem) throw new Exception("Please select an item");    
        oboAppSvc.removeApp( [objid: selectedItem.objid ]);
        reloadNodes();
        listHandler.reload();
    }

}


