package com.rameses.gov.etracs.obo.models;

import com.rameses.rcp.annotations.*;
import com.rameses.rcp.common.*;
import com.rameses.seti2.models.*;
import com.rameses.util.*;
import com.rameses.osiris2.common.*;
import com.rameses.osiris2.client.*;
import com.rameses.common.*;

public class OboAppFormModel extends WorkflowTaskModel implements IFormContext {

    //@Service("JasperEmailQueueService")
    //def emailSvc;
    
    //@Service("OboAppFeeService")
    //def appFeeSvc;
    
    //@Service("OboAppService")
    //def appSvc;

    @Service("SysReportService")
    def reportSvc;
    
    @Service("SysMessageSenderService")
    def senderSvc;

    @Service("OboBillingService")
    def billingSvc;

    boolean viewReportAllowed = true;
    boolean editAllowed = true;

    //IFormContext implementation
    public String getFormContext() {
        return "application";
    }

    public String getAppid() {
        return entity.objid;       
    }

    public String getAppno() {
        return entity.appno;       
    }

    public String getAppClassid() {
        return entity.appclassid;       
    }

    public String getAppState() {
        return entity.task.state;       
    }

    public String getAppType() {
        return getProcessName();
    }
    //-- IFormContext implementation


    public String getTitle() {
        return getCaption() + " " + (entity.appno==null? 'Tracking No '+ entity.trackingno: 'App No ' + entity.appno) + " [" +  task?.title + "]" ;
    }
    
    public String getCaption() {
        return invoker.properties.caption;        
    }
    
    public String getWindowTitle() {
        return  (entity.appno==null? entity.trackingno : entity.appno);
    }
    
    public String getNotificationid() {
        return workunit?.info?.workunit_properties?.notificationid;
    }
    
    public String getSchemaName() {
        return workunit?.info?.workunit_properties?.schemaName;        
    }

    public String getEntitySchemaName() {
        return "obo_app";        
    }


    public def edit() {
        return showDropdownMenu( "edit" );
    }

    public void assignAppno() {
        if(!MsgBox.confirm("You are about to generate the application no. Proceed?")) return;
        def z = [_schemaname: processName + "_task"];
        z.findBy = [refid: entity.objid];
        z.select = "enddate";
        z.where = ["state = 'requirement-verification' "];
        z.orderBy = "dtcreated DESC";
        def d = queryService.findFirst(z);
        appSvc.assignAppno([appid: entity.objid, appdate: d.enddate ]);
        reloadEntity();
    }

    public def getSections() {
        def commonSections = Inv.lookupOpeners( "obo_app:sections", [caller:this] );
        def customSections = Inv.lookupOpeners( appClassid.toLowerCase() + ":sections", [caller:this] );
        return (commonSections + customSections).sort{ it.properties.index }
    }

    def showReport( def o ) {
        def pp = [:];
        pp.query = [objid: entity.objid ]
        pp.reportDef = reportSvc.findReportDef( name: o.name );
        pp.connection = "obo";
        pp.title =  entity.doctitle + " Reports"
        pp.defaultEmail = entity.contact?.email;
        def op = Inv.lookupOpener( "sys_report_form", pp );
        op.target = "popup";
        return op;
    }

    def viewReport() {
        def categories = [];
        categories  << "obo_app:reports";
        categories <<  appClassid.toLowerCase() + ":form:reports";
        def opMenu = new PopupMenuOpener();
        try {
            def list = reportSvc.getListByCategory([ category: categories ] );
            list.each { entry ->
                boolean included = true;
                if( !entry.template ) {
                    included = false;
                }
                else if( entry.visiblewhen ) {
                    try { 
                        included = ExpressionResolver.getInstance().evalBoolean(entry.visiblewhen, [entity:entity, task: task ] ); 
                    }
                    catch(ex) {
                        ex.printStackTrace();
                    }
                }
                if(included) {
                    opMenu.add( new PopupAction(name:"showReport", caption:entry.title, parameters: entry, obj: this ) );     
                }
                /*
                if(entry.outputTemplates) {
                    entry.outputTemplates.each { ot->
                        ot.reportid = entry.name;
                        opMenu.add( new PopupAction(name:"launchViewer", caption:ot.caption, parameters: ot, obj: this ) );     
                    }
                }
                */

            }
        } 
        catch(Throwable ign){;}
        if(opMenu.items.size()==0) throw new Exception("No reports defined in category in " + categories.join(","));
        return opMenu;  
    }    
    
    def emailDocs() {
        def s = { o->
            def s = appClassid.toLowerCase() + "_docs";
            senderSvc.send( [templateid: s, params: [objid: entity.objid, email: o.email ]]  );
        }
        return Inv.lookupOpener( "sys_specify_email", [email: entity.contact.email, handler: s] );
    }

    def generateBill() {
        if(!MsgBox.confirm("You are about to create a new bill. Proceed?"))
            throw new BreakException();
        def m = [appid: entity.objid, appno: entity.appno ];
        def bill = billingSvc.createBill( m );
        entity.bill = bill;
        entity.billid = bill.objid;
        binding.refresh();
        return viewBill();
    }

    def viewBill() {
        if(!entity.bill?.objid) throw new Exception("There is no bill generated yet");
        return Inv.lookupOpener("obo_bill:open", [bill: entity.bill ]);    
    }

    
    def viewProgress() {
        return Inv.lookupOpener( "obo_app_tracking", [entity:[objid:entity.objid]] );
    }
    /*
    def viewReceipt() {
        if(!entity.payment.refid) throw new Exception("Payment refid is not specified for this payment");
        def op = Inv.lookupOpener(entity.payment.reftype + ":open", [entity:[objid:entity.payment.refid]] );
        op.target = "popup";
        return op;
    }
    */


}


