package com.rameses.gov.etracs.obo.models;

import com.rameses.rcp.annotations.*;
import com.rameses.rcp.common.*;
import com.rameses.seti2.models.*;
import com.rameses.util.*;
import com.rameses.osiris2.common.*;
import com.rameses.osiris2.client.*;

/**
* Notes on who can edit findings:
* 
*
* finding status:
*    1 = closed
*    2 = open
*/  
class OboAppFindingListModel extends AppFormSectionListModel {

    def viewState = 2;

    def sectionList;
    def selectedSection;

    String checklistid;

    def checkListUtil = new CheckListUtil();

    @PropertyChangeListener
    def listener = [
        "viewState" : { o->
            refresh();
        },
        "selectedSection" : { o->
            refresh();    
        }
    ];

    String getEditState() {
        return invoker.properties.editState;
    }

    //you can only add or edit within a section not in the application level  
    boolean getCanEdit() {
        boolean retval = false;
        if( formContext == "taskitem" ) {
            if( task.tracktime != 1 ) return false;
            retval = isTaskAssignee();
        }
        return retval;
    } 

    void init() {
        def m = [_schemaname: "obo_taskitem_type"];
        m.findBy = [appclassid: appClassid];
        m.where =  ["NOT(sectionid IS NULL)"];
        sectionList = queryService.getList( m ).collect{ [ objid: it.sectionid, title: it.section.title, 
            org: it.section?.org, checklistid: it.checklistid, tasktypeid: it.objid ] }; 
        ;
        if(entity.sectionid ) {
            selectedSection = sectionList.find{ it.objid == entity.sectionid };
        }
    }
    
    boolean getEditable() {
        return true;
    }

    def fetchList( def o ) {
        def m = [_schemaname: "vw_obo_app_finding"];
        m.findBy = [appid: appid ];
        def arr = ["superseded=0"];
        def params = [:];

        if( selectedSection?.objid ) {
            arr << "sectionid = :sectionid";
            params.sectionid = selectedSection.objid;
        }
        if( viewState  ) {
            arr << "state = :state";
            params.state = viewState;
        }
        if( arr ) {
            m.where = [ arr.join( " AND "), params ];    
        }

        m.orderBy = "section.title,checklistitem.indexno"
        def list = queryService.getList( m );
        return  checkListUtil.formatList( list );
    }

    boolean isOwnerEditor() {
        return selectedItem.createdby?.objid == userid;
    }

    void validateSection() {
              
    }

    //saves the new item;
    def saveNewItem = {e ->
         def m = [_schemaname: "obo_app_finding"];
         m.putAll( e );
         m.appid = appid;
         persistenceService.create( m );            
         refresh();
    }

    def addItem() {
        def _selectedSection = selectedSection;
        if( entity.sectionid ) {
            _selectedSection = sectionList.find{ it.objid == entity.sectionid };
        }
        if(!_selectedSection) throw new Exception("Please select a section");
        if(!isSameOrg( _selectedSection.org?.objid ))
            throw new Exception("You cannot add section that does not belong to your org"); 
        if( !_selectedSection.checklistid )    
            throw new Exception("Please specify checklist in " + _selectedSection.tasktypeid );
        def p = [ checklistid: _selectedSection.checklistid ];
        p.section = selectedSection;
        p.saveHandler = saveNewItem;
        return Inv.lookupOpener("obo_app_finding:create", p );
    }

    void removeItem(def sitem) {
        if(!ownerEditor) throw new Exception("Only editor of the entry can remove this item. Use supersede instead");
        if(sitem.transmittalid) throw new Exception("Cannot remove an item that has already been transmitted");
        if(!isSameOrg( sitem.section.org?.objid ))
            throw new Exception("You cannot add section that does not belong to your org"); 
        def m = [_schemaname: "obo_app_finding"];
        m.findBy = [objid: sitem.objid ];
        persistenceService.removeEntity( m );
    }

    def supersedeItem() {
        if(!selectedItem) throw new Exception("Please select an item");
        if(ownerEditor && !selectedItem.transmittalid) 
            throw new Exception("You are editor of this entry. Use view item instead");
        if(!isSameOrg( selectedItem.section.org?.objid ))
            throw new Exception("You cannot add section that does not belong to your org");  
        def p = [superseded: selectedItem];
        p.section = selectedItem.section;
        p.saveHandler = saveNewItem;
        return Inv.lookupOpener("obo_app_finding:supersede", p );
    } 
    
    boolean isVisible() {
        return false;
    }

    def viewItem(def sitem) {
        def m = [_schemaname: "vw_obo_app_finding"];
        m.findBy = [objid: sitem.objid];
        def r = queryService.findFirst( m );
        def p = [entity:r];
        p.section = sectionList.find{ it.objid == r.sectionid };
        if( ownerEditor ) {
            p.editable = (!sitem.transmittalid) ? true : false ;
            p.saveHandler = { e->
                def m1 = [_schemaname: "obo_app_finding"];
                e.appid = appid;
                m1.putAll( e );
                persistenceService.update( m1 );            
                refresh();
            }
        }
        return Inv.lookupOpener("obo_app_finding:open", p );
    }

    def viewTransmittal() {
        if( !selectedItem.transmittalid ) 
            throw new Exception("This item has not yet been transmitted");
        def m = [_schemaname: "obo_app_transmittal"];
        m.findBy = [objid: selectedItem.transmittalid ];
        def t = queryService.findFirst( m );    

        def  p = [:];
        p.reportid = t.doctype.reportid;
        p.query = [objid: t.objid ];
        p.connection = "obo";
        def op = Inv.lookupOpener( "sys_report_form", p );
        op.target = "popup";
        return op;
    }

}


