package com.rameses.gov.etracs.obo.models;

import com.rameses.rcp.annotations.*;
import com.rameses.rcp.common.*;
import com.rameses.seti2.models.*;
import com.rameses.osiris2.common.*;
import com.rameses.util.*;
import com.rameses.common.*;
import com.rameses.osiris2.client.*;
import com.rameses.rcp.framework.ClientContext;
import com.rameses.jasper.models.*;


class OboAppDocPrintoutModel extends SysReportFormModel {
    
    @Caller
    def caller;

    def _rptInfo;

    def entity;

    def preview() {
        def reportid = entity.reportid;
        if(!reportid) throw new Exception("Please specify reportid in " + entity.doctype.code );
        connection = "obo";
        reportDef = getReportService().findReportDef( [name: reportid ] );
        query = [objid: entity.objid];
        mode = "preview";
        return super.init();
    }

    public String getDefaultEmail() {
        def c = caller?.entity;
        if( c ) {
            return c.contact?.email;
        }
        else {
            return null;
        }
    }

    public boolean isAllowPrint() {
        return true;
    }
  
    public boolean isAllowSave() {
        return true;
    }

    public def sendEmail() {
        def s = { o->
            def parms = [:];
            parms.objid = entity.objid;
            parms.email = o.email;
            messageSenderService.sender( [ templateid: "obo_app_doc", params: parms ] );
        }
        return Inv.lookupOpener( "sys_specify_email", [email: defaultEmail, handler: s] );
    }

}