package com.rameses.gov.etracs.obo.models;

import com.rameses.rcp.annotations.*;
import com.rameses.rcp.common.*;
import com.rameses.seti2.models.*;
import com.rameses.osiris2.common.*;
import com.rameses.util.*;
import com.rameses.osiris2.client.*;
import com.rameses.rcp.framework.ClientContext;
import java.awt.*;

class OboAppDocModel extends CrudFormModel {
    
    @Service("OboAppDocService")
    def appDocSvc;
    
    @Service("SysReportGeneratorService")
    def rptSvc;

    @Service("SysMessageSenderService")
    def senderSvc;

    @FormId
    public String getFormid() {
        return "obo_app_doc:" + entity.objid;
    }
    
    boolean editable;
    boolean showInfos;
    boolean showChecklist;
    boolean showFees;
    

    boolean manualIssue;
    
    def docList;
    boolean showDocList;
    def selectedRefDoc;
    def worktypetext;
    
    //this needs to be set outside except if there is no parent context
    boolean canPrint;
    boolean canIssue;
    boolean canAssess;
    boolean canEdit;
    
    public String getAppType() {
        return entity.app.appclass?.toLowerCase();
    }

    public String getAppState() {
        return entity.task.state;
    }

    public String getTitle() {
        return entity.doctype.title;
    }

    void afterOpen() {
        showChecklist = entity.showchecklist;
        showInfos = entity.showinfo;
        showFees = entity.showfees;
        //if there is an app no. and manually issued and no controlid yet
        if( entity.app.appno && entity.doctype.issuetype == 1 && !entity.controlid ) {
            canIssue = true;
        }
    }

    /* ************************************************************************
    * INFOS ADDED IN THE DOCUMENT
    *************************************************************************/
    void editRemarks() {
        def p = [:];
        p.fields = [
            [caption:'Remarks', name:'remarks', type:'textarea', preferredSize: '0,180' ]
        ];
        p.data = [
            remarks: entity.remarks
        ];
        p.handler = { o->
            def e = [_schemaname: "obo_app_doc"];
            e.objid = entity.objid;
            e.remarks = o.remarks;
            persistenceService.update(e);
            entity.remarks = o.remarks;
            binding.refresh();
        }
        Modal.show("dynamic:form", p, [title: "Enter Remarks/Conditions", width: 800, height: 400 ] );
    }
    
    //additional work types
    /*
    def editWorktypes() {
        def p = [:];
        p.onselect = { o->
            def e = [_schemaname: schemaName];
            e.objid = entity.objid;
            e.worktypes = o*.objid;
            persistenceService.update(e);
            entity.worktypes = e.worktypes;
            binding.refresh();
        };
        p.put("query.typeid", [typeid: entity.doctypeid ]);
        return Inv.lookupOpener("obo_work_type:lookup", p );
    }
    
    public String getWorktypesText() {
        if( entity.worktypes == null ) return "";
        return entity.worktypes.join(",");
    }
    */

    //this is the main issuance
    def issueControl() {
        def p = [:];
        p.saveHandler = { v->
            def c = appDocSvc.issueControl( [docid: entity.objid, controlno: v.controlno ]  );
            entity.controlid = c.objid;
            entity.controlno = c.controlno;
            entity.issuedby = v.issuedby;
            canIssue = false;
            binding.refresh();
        }
        return Inv.lookupOpener("obo_control:create", p); 
    }
    
    def reloadEntity() {
        def r = super.reloadEntity();
        docListHandler.reload();
        return r;
    }
    
    public def viewApplication() {
        def op = Inv.lookupOpener(appType + ":open", [entity: [objid: entity.appid ]]);
        op.target = "self";
        return op;
    }
    
    public boolean getAllowShowApplication() {
        if(caller instanceof AppFormSectionListModel) {
            return false;
        }
        else {
            return true;
        }
    }

    public void viewFromWeb() {
       def weburl = rptSvc.buildWebUrl( [reportid: entity.reportid, objid: entity.objid] ); 
       Desktop.getDesktop().browse( new URL(weburl).toURI() );   
    }

    //this is used to show the button
    public boolean isViewReportAllowed() {
        return (entity.template !=null);
    }

    public def preview() {
        return Inv.lookupOpener( "obo_app_doc_printout", [entity: entity]);
    }

    public def viewReport() {
        return Inv.lookupOpener( "obo_app_doc_printout", [entity: entity]);
    }

    public def sendEmail() {
        def s = { o->
            senderSvc.send( [templateid: "obo_app_doc", params:[objid: entity.objid, email: o.email ]] );
        }
        return Inv.lookupOpener( "sys_specify_email", [email: entity.app?.contact?.email, handler: s] );
    }


}