package com.rameses.gov.etracs.obo.models;

import com.rameses.rcp.annotations.*;
import com.rameses.rcp.common.*;
import com.rameses.seti2.models.*;
import com.rameses.util.*;
import com.rameses.osiris2.common.*;
import com.rameses.osiris2.client.*;

class OboAppDocListModel extends AppFormSectionListModel {


    @Service("OboAppDocService")
    def docSvc;

    
    String schemaName= "vw_obo_app_doc";
    String entitySchemaName = "obo_app_doc";
    
    //determines who can add or remove items.

    String getEditState() {
        return invoker.properties.editState;
    }

    boolean getCanEdit() {
        if( formContext == "application" ) {
            if( task.tracktime != 1 ) return false;
            if( editState && appState.matches( editState ) ) {
                return isTaskAssignee();
            }  
            else {
                return hasRole("COORDINATOR");      
            }  
        }
        else if( formContext == "taskitem" ) {
            return isTaskAssignee();
        }
        return false;
    } 

    String getAssessState() {
        return invoker.properties.assessState;
    }

    boolean getCanAssess() {
        if( formContext == "application" ) {
            if( entity.billid ) return false;
            if( assessState && appState.matches( assessState ) ) {
                return hasRole("COORDINATOR");      
            }  
        }
        else if( formContext == "taskitem" ) {
            return isTaskAssignee();
        }
        return false;        
    }

    def viewItem( def r ) {
        def p = [:];
        p.entity = r;
        p.app = entity;
        p.canEdit = getCanEdit();
        p.canAssess = getCanAssess(); 

        def op = Inv.lookupOpener(schemaName + ":open", p );
        op.target = "popup";
        return op;
    }

    def  fetchList( def o ) {
        def m = [_schemaname: schemaName];
        m.findBy = [appid: appid];
        if(sectionid !=null) {
            m.where = ["doctype.sectionid = :sectionid", [sectionid: sectionid ] ];
        }
        return queryService.getList( m );        
    }
    
    def addItem() {
        def h = [:]
        h.onselect = { o->
            if(!isOrgroot() && !isSameOrg( o.section?.org?.objid ) ) {
                throw new Exception("You cannot add document not in the same org.");
            }
            def pq = [_schemaname: entitySchemaName];
            pq.appid = appid;
            pq.doctypeid = o.objid;
            pq.doctype = [objid: o.objid ];
            pq.state = 0;
            pq.amount = 0;
            persistenceService.create( pq );
            listHandler.reload();
        }

        def str = "obo_doctype:all:lookup";
        if(! isOrgroot() ) {
            str = "obo_doctype:org:lookup";
            h.query = [orgid: orgid ]
        }
        else if( sectionid ) {
            str = "obo_doctype:section:lookup";
            h.query = [sectionid: sectionid ]    
        }
        return Inv.lookupOpener( str , h );
    }
    
    void removeItem( r ) {
        if( !isSameOrg( r.org?.objid ) ) {
            if(! hasRole("COORDINATOR")) {
                throw new Exception("You cannot remove document not in the same org.");                          
            }      
        }
        def u = [_schemaname: entitySchemaName];
        u.objid = r.objid;
        persistenceService.removeEntity( u );
    }
    
    void execRules() {
        docSvc.execDocRules( [appid: appid ] );
        listHandler.reload();
    }

    def printPreview() {
        if(!selectedItem) throw new Exception("Please select an item");
        def op = Inv.lookupOpener( "obo_app_doc_printout", [entity: selectedItem]);
        op.target = "popup";
        return op;
    }

    /*
    @Service("OboAppFeeService")
    def appFeeSvc;
 
    public boolean getShowAssessAll()  {
        def tstate = parentObject.task.state;
        def assid = parentObject.task.assignee?.objid;
        return (apptype != "taskitem" && tstate.matches('.*assessment.*') && (assid == userid) );
    }

    void assessAll() {
        if(!MsgBox.confirm("You are about to assess all fees not computed. Proceed?")) return;
        appFeeSvc.assessAll( [appid: entity.objid ] );
        listHandler.reload();
    }
    */    
    
}


