package com.rameses.gov.etracs.obo.models;

import com.rameses.rcp.annotations.*;
import com.rameses.rcp.common.*;
import com.rameses.seti2.models.*;
import com.rameses.util.*;
import com.rameses.osiris2.common.*;
import com.rameses.osiris2.client.*;

class OboAppDocInfoListModel extends AppFormSectionListModel  {

	@Service("OboAppDocInfoService")
    def infoSvc;

    def infos;

    public boolean getCanEdit() {
        if( caller.getCanAssess() ) {
            return true;
        }   
        return caller.getCanEdit();
    }
     
    public def fetchList (def o ) {
        infos = infoSvc.getInfos( [parentid: entity.objid ] );
        infos.each {
            if(it.datatype == "lookup") {
                it.displayvalue = it.value.key+"-"+it.value.title;
            }
            else {
                it.displayvalue = it.value;
            }
        }
        return infos;
    }

    boolean isMultiSelect() {
        return true;
    }

    void saveInfos(def items) {
        def _infos = [];
        items.each { v->
            def existInfo = infos.find{it.name == v.name};
            if( !existInfo ) {
                v.objid = null;
                v.parentid = entity.objid;
                v.appid = entity.appid;
                _infos << v;
            }
            else {
                existInfo.value =  v.value;
                _infos << existInfo;                    
            }
        }
        infoSvc.saveInfos( [ items: _infos] );
        listHandler.load();
    }
    
    def addInfos() {
        def p = [:];
        p.onselect = { o->
            saveInfos(o);
        }
        def filter = []
        p.typeid =  entity.doctypeid; 
        return Inv.lookupOpener( "obo_variable:picklist", p );
    }
    
    def editInfos() {
        def selectedItems = listHandler.getSelectedValue();
        if( !selectedItems ) throw new Exception("Please select items to edit");
        def h = { o->
            saveInfos(o);
        }
        def op = Inv.lookupOpener("obo_detail_info", [items: selectedItems, onselect: h ]);
        op.target = "popup";
        return op;
    }
    
    void removeInfos() {
        def selectedItems = listHandler.getSelectedValue();
        if( !selectedItems ) throw new Exception("Please select items to remove");
        infoSvc.removeInfos( [items: selectedItems] );
        listHandler.load();
    }

    void editRemarks() {
        if( !selectedItem ) return;
        def msg = MsgBox.prompt("Enter Remarks");
        if(msg) {
            selectedItem.remarks = msg;
            def u = [_schemaname:"obo_app_doc_info"];
            u.objid = selectedItem.objid;
            u.remarks = msg;
            persistenceService.update( u );
            binding.refresh();
        }
    }
    
    void test() {
        MsgBox.alert("fire test");
    }
    

    
}
