package com.rameses.gov.etracs.obo.models;

import com.rameses.rcp.annotations.*;
import com.rameses.rcp.common.*;
import com.rameses.seti2.models.*;
import com.rameses.util.*;
import com.rameses.osiris2.common.*;
import com.rameses.osiris2.client.*;

class OboAppDocFeeListModel extends AppFormSectionListModel {

    @Service("OboAppFeeService")
    def feeSvc;
    
    def fetchList( def o ) {
        def list = feeSvc.getFees( [docid: entity.objid ]  );
        entity.amount = list.sum{ it.amount };
        return list;    
    }
    
    public boolean getCanEdit() {
        return caller.getCanEdit();
    }
    
    public boolean getCanAssess() {
        return caller.getCanAssess();
    }

    def addItem() {
        def m = [:];
        m.doctypeid = entity.doctypeid;
        m.entity = [:];
        m.saveHandler = { o->
            o.appid = entity.appid;
            o.docid = entity.objid;
            feeSvc.saveFee( o );
            listHandler.reload();  
            binding.refresh();
        }
        return Inv.lookupOpener("obo_app_fee", m );
    }
    
    
    void removeItem(def sitem) {
        feeSvc.removeFee( [objid: sitem.objid, docid: entity.objid ] );
    }
    
    void clearFees() {
        def v = [:];
        v.docid = entity.objid;
        v.appid = entity.appid;
        feeSvc.clearFees( v );
        listHandler.reload();
    }
    
    def assess() {
        def f = [:];
        f.appid = entity.appid;
        f.docid = entity.objid;
        def h  = { u->
            f.items = u.items;
            feeSvc.saveFees(  f );
            listHandler.reload();
            binding.refresh();
        }
        return Inv.lookupOpener( "obo_app_fee:assessment", [params: f, handler: h ] );
    }

    void exemptFees() {
        feeSvc.updateExemptFees( [docid: entity.objid, exemptfees: 1 ] );
        entity.exemptfees = 1;
        binding.refresh();
    }

    void unexemptFees() {
        feeSvc.updateExemptFees( [docid: entity.objid, exemptfees: 0 ] );
        entity.exemptfees = 0;
        binding.refresh();
    }
    
}
