package com.rameses.gov.etracs.obo.models;

import com.rameses.rcp.annotations.*;
import com.rameses.rcp.common.*;
import com.rameses.seti2.models.*;
import com.rameses.osiris2.common.*;
import com.rameses.util.*;
import com.rameses.osiris2.common.*;
import com.rameses.rcp.common.*;
import com.rameses.osiris2.client.*;
import com.rameses.enterprise.models.*;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileNameExtensionFilter;
import obo.util.*;

class OboAppDocChecklistModel {

    @Binding
    def binding;

    def entity;
    def saveHandler;
    def subject;

    def checkListEditor ;

    def selectedItem;
    def checklistid;
    boolean editable;
    def subform;

    def mode;

    def lookupChecklist() {
        def p = [:];
        p.query = [checklistid: checklistid];
        p.onselect = { c->
            entity.checklistitem = c;
            entity.typeid = c.objid;
            entity.values = [];
            checkListEditor = new CheckListEditor( c.title, entity.values ); 
            subject = checkListEditor.text;
            binding.fireNavigation("default");
        };
        p.oncancel = {
            binding.fireNavigation("_close");
        }   
        return Inv.lookupOpener( "obo_checklist_item:lookup", p );
    }

    def create() {
        editable = true;
        entity = [:];
        entity.state = 2;
        mode = "create";
        subform = lookupChecklist();
        return "select-item";
    }

    void open() {
        checkListEditor = new CheckListEditor( c.title, entity.values );
        subject = checkListEditor.text; 
        mode = "open";
    }

    //this is filter for obo_checklist_item
    void init() {

    }

    void setParam( def o ) {
        checkListEditor.setParam( o );
        subject = checkListEditor.text;
        binding.refresh();
    }

    void editParameters() {
        setParam( null );    
    }

    

    def doNext() {
        entity.type = selectedItem;
        entity.typeid = selectedItem.objid;
        rebuildSubject();
        return "default";
    }

    def doOk() {
        if(editable) {
            if( checkListEditor.params && !checkListEditor.values )
                throw new Exception("Please specify values for the parameters");
            entity.values = checkListEditor.values;    
            saveHandler( entity );
        }
        return "_close";
    }

    def doCancel() {
        return "_close";
    }

    


}