package com.rameses.gov.etracs.obo.models;

import com.rameses.rcp.annotations.*;
import com.rameses.rcp.common.*;
import com.rameses.seti2.models.*;
import com.rameses.util.*;
import com.rameses.osiris2.common.*;
import com.rameses.osiris2.client.*;
import obo.util.*;

class OboAppDocChecklistListModel extends AppFormSectionListModel {

    def ch = new CheckListUtil();
    
    public boolean getCanEdit() {
        return  caller.getCanEdit();
    }
   
    def fetchList(def o ) {
        def m = [_schemaname: "obo_app_doc_checklist"];
        m.findBy = [parentid: entity.objid ];
        def list = queryService.getList( m );
        return ch.formatList( list );
    }

    public def addItems() {
        def p = [ checklistid: entity.checklistid ];
        p.saveHandler = {e ->
             def m = [_schemaname: "obo_app_doc_checklist"];
             m.putAll( e );
             m.appid = caller.entity.appid;
             m.parentid = caller.entity.objid;
             persistenceService.create( m );            
             refresh();
        }
        return Inv.lookupOpener("obo_app_doc_checklist:create", p );
    }
    
    void removeItem(def sitem) {
        def m = [_schemaname: "obo_app_doc_checklist"];
        m.findBy = [objid: sitem.objid ];
        persistenceService.removeEntity( m );
    }

    public def viewItem( def sitem ) {
        def p = [ checklistid: entity.checklistid, entity: sitem ];
        p.saveHandler = {e ->
            def m = [_schemaname: "obo_app_doc_checklist"];
            m.putAll( e );
            persistenceService.update( m );            
            refresh();
        }
        p.editable = true;
        return Inv.lookupOpener("obo_app_doc_checklist:open", p );   
    }
    
    
}
