package com.rameses.gov.etracs.obo.models;

import com.rameses.rcp.annotations.*;
import com.rameses.rcp.common.*;
import com.rameses.rcp.framework.ClientContext;
import com.rameses.util.*;
import com.rameses.seti2.models.*;
import com.rameses.osiris2.common.*;
import com.rameses.osiris2.client.*;
import com.rameses.enterprise.models.*;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileNameExtensionFilter;

class OboAppAttachmentUploadModel {

    @Service("PersistenceService")
    def persistenceSvc;
    
    @Service("QueryService")
    def querySvc;
    
    @Binding
    def binding;
    
    def attachmentTypes;
    
    def entity;
    def appid;
    def filedir;
    def file;
    def previd;
    def saveHandler;
    def type;
    def stat = [totalcount:0, counter:0];
    boolean processing = false;
    
    int version = 1;

    boolean fileitem;
    
    void afterInit() {
        //do not load type if superseded was called i.e. typeid was specfied
        if(!type) {
            def m = [_schemaname: "obo_attachment_type"]
            m.where = ["1=1"];
            attachmentTypes = querySvc.getList(m);
        }
        else {
            attachmentTypes = [type];
        }
    }
    
    void create() {
        entity = [ objid: 'FILE'+ new java.rmi.server.UID() ]; 
        entity.appid = appid;
        if( previd ) {
            entity.supersededid = previd;
        }
        afterInit();
    }
    
    void createItem() {
        fileitem = true;         
    }

    void previewFile() {
        if(!file) throw new Exception("Please select file");
        String sfile = file.toString();
        def url = file.toURI().toURL(); 
        if( sfile.endsWith("pdf")) {
            PDFViewer.show(url, null);
        }
        else {
            def op = Inv.lookupOpener("app_common:image-viewer", [image: url] );
            Modal.show( op );
        }
    }

    def removeFile() {
        file = null;
    }

    void addAttachment() {
        def jfc = new JFileChooser();
        if( fileitem) {
            //if item apply only for image types
            jfc.setFileFilter(new FileNameExtensionFilter("Files", "jpg", "jpeg", "png"));    
        }
        else {
            jfc.setFileFilter(new FileNameExtensionFilter("Files", "jpg", "jpeg", "png", "pdf"));    
        }
        jfc.setFileSelectionMode( JFileChooser.FILES_ONLY );
        int retval = jfc.showOpenDialog(null); 
        if (retval == JFileChooser.APPROVE_OPTION) {
            file = jfc.selectedFile;
       } 
    }

    def doOk() {
        if(!file) throw new Exception("Please select a file first");
        if( !MsgBox.confirm("You are about to transfer online data to the system. Proceed? ")) return;

        if(!fileitem) {
            entity.fileitem = false;
            entity.typeid = type.objid;
            entity.title = type.title;
            entity.version = version;
            entity.filetype = file.name.substring( file.name.lastIndexOf(".") + 1 );            
        }
        else {
            entity.fileitem =  true;
        }

        def uploader = new FileUploader( entity );
        uploader.connection = "obo";
        uploader.fileDir = filedir;

        if(fileitem) {
            uploader.append = true;
        }

        uploader.addListener( 
            [
                onStart: { 
                    processing = true;
                    binding.refresh(); 
                },
                onProcess: { v-> 
                    stat.totalcount = v.filesize;
                    stat.counter = v.bytestransferred;
                    progressBarHandler.refresh();
                    Thread.sleep(50);
                },
                onEnd: {
                    saveHandler( entity );
                    binding.fireNavigation("_close");
                }
            ] as FileUploadListener
        );
        //uploader.setFileDir(  )
        
        def appEnv = ClientContext.getCurrentContext().getAppEnv(); 
        def keyName = [ uploader.connection, "filemgmt.connection" ].findAll{ it }.join(".");
        def connFileName = appEnv.get( keyName );
        if( connFileName != null && connFileName.trim().length() > 0 ) {
            uploader.setFileLocId( connFileName );
        } else {
            uploader.setFileLocId( "default" );
        }        
        uploader.addFile( file.getAbsoluteFile() );    
        uploader.execute();

        return null;    
    }
    
    def progressBarHandler = [
        getMaxValue : {
            return stat.totalcount;
        },
        getValue: {
            return stat.counter;
        }
    ] as ProgressModel; 


    def doCancel() {
        return "_close";
    }
    

    
}