package com.rameses.gov.etracs.obo.models;

import com.rameses.rcp.annotations.*;
import com.rameses.rcp.common.*;
import com.rameses.seti2.models.*;
import com.rameses.util.*;
import com.rameses.osiris2.common.*;
import com.rameses.osiris2.client.*;
import java.awt.*;

public class OboAppAttachmentListModel extends AppFormSectionListModel  {

    @Service( "SysFileService" )
    def fileSvc;

    public boolean getCanEdit() {
        if( formContext == "application" ) {
            if( task.tracktime != 1) return false;
            if( appState == "requirement-verification" ) {
                return isTaskAssignee();
            }
            else {
                return hasRole("COORDINATOR");    
            }
        }
        else if( formContext=="taskitem" ) {
            return taskAssignee;    
        }
        return false;
    }    

    public def fetchList( def o ) {
        def m = [ _schemaname: "vw_obo_app_attachment"];
        m.findBy = [appid: getAppid() ];
        m.where = ["superseded = 0"];
        return queryService.getList( m );    
    }

    def addItem() {
        def s = { o->
            refresh();
        }
        def fdir = getAppType()?.toUpperCase() + "/" + getAppno();
        return Inv.lookupOpener( "obo_app_attachment:create", [appid: caller.getAppid(), saveHandler: s, filedir: fdir ] );
    }
    
    void removeItem(def item) {
        fileSvc.remove( [objid: item.objid, fileitem:false ] );              
    }
    
    def viewItem(def sitem, def viewer ) {
        if(!sitem) throw new Exception("Please select an item");
        
        if( sitem.filetype == 'pdf' ) {
            def r = [_schemaname: "sys_fileitem"];
            r.findBy = [parentid: sitem.objid ];
            def fileitem = queryService.findFirst( r ); 
            def upd = new FileDownloader( fileitem );
            upd.connection = "obo";
            def item = upd.open(); 
            def url = upd.createURL(); 

            if(viewer==null) {
                PDFViewer.show(url, null);
            }
            else if(viewer=="browser") {
                Desktop.getDesktop().browse( url.toURI() );
            }
            //Desktop.getDesktop().open( file );
        }
        else {
            def op = Inv.lookupOpener("obo_image_attachment:open", [file: sitem ]);
            Modal.show( op );
        }
    }  
    
    def viewItem(def sitem ) {
        return viewItem(sitem, null);
    } 
    
    def viewItemInBrowser() {
        if(!selectedItem) throw new Exception("Please select an item");
        return viewItem(selectedItem, "browser" );
    }
    
    def supersedeItem() {
        if(!selectedItem) throw new Exception("Please select an item");
        def p = [:];
        p.previd = selectedItem.objid;
        p.version = selectedItem.version + 1;
        p.type = [objid:selectedItem.typeid, title:selectedItem.title];
        p.saveHandler = { o->
            refresh();
        };
        p.appid = caller.getAppid();
        return Inv.lookupOpener( "obo_app_attachment:create", p );
    }

}


