package com.rameses.gov.etracs.obo.models;

import com.rameses.rcp.annotations.*;
import com.rameses.rcp.common.*;
import com.rameses.seti2.models.*;
import com.rameses.osiris2.common.*;
import com.rameses.util.*;
import com.rameses.osiris2.client.*;

class CheckListEditor {
    
    def varName;
    def origText;
    def text;
    def params = [];
    def values = [];
    
    public CheckListEditor() {
    }
    
    public CheckListEditor( def str, def vals ) {
        this.origText = str;
        if(vals) this.values = vals;
        rebuildText();

    }
    
    void rebuildText() {
        if(!this.origText) return;
        if( this.origText == "{S}" ) this.origText = "{s}";
        if( this.origText == "{s}" && !this.values ) {
            text = "";
        }
        else {
            def s = this.origText.replaceAll("\n","") =~ /\{\w\}/ 
            int i = 0;
            def sb = new StringBuffer();
            sb.append("<html>");
            sb.append("<body>");
            sb.append("<font size='2'>");
            while (s.find()) {
               if(values.size()-1 <= i) values << "";
               def val = values[i];
               if( !val ) val = "?";
               s.appendReplacement(sb,"<a id='" + (i++) + "' href='setParam'>&nbsp;" + val + "&nbsp;</a>" ); 
               params << s.group()[1];
            } 
            s.appendTail(sb);
            sb.append("</font>");
            sb.append( "</body>");        
            sb.append( "</html>");
            text = sb.toString();    
        }        
    }

    /*
    public void setParam(def o ) {
        int i = o.id.toInteger();
        def p = params[i];
        def v = values[i];

        def info = [caption:"Enter Value", value: v];
        if( p == "n" ) info.datatype = "decimal";
        else if( p == "i" ) info.datatype = "integer";
        else if( p == "d" ) info.datatype = "date";        
        else info.datatype = "text";
        
        def items = [ info ];
        def onselect = { z->  
            values[i] = z[0].value;
            rebuildText();
        };
        Modal.show("obo_detail_info", [items:items, onselect: onselect]);
    }
    */
   
    public void setParam(def o) {
        def h = { u->
            values = u.values;
            rebuildText();
        }
        def e = [template:origText, values:values]
        Modal.show( "obo_checklist_editor", [entity:e, handler:h] )
    }
    
    public def format( def txt, def vals ) {
        if(vals==null) vals = [];
        def s = txt =~ /\{\w\}/ ;
        def sb = new StringBuffer();
        int i = 0;
        while (s.find()) {
           if(vals.size()-1 <= i) vals << "";
           def val = vals[i++];
           if( !val ) val = "?";
           s.appendReplacement(sb,"<u>"+val+"</u>"); 
        } 
        s.appendTail(sb);
        return sb.toString();
    }
    
    public def parse( def txt, def vals ) {
        if(vals==null) vals = [];
        def zparams = [];
        def s = txt =~ /\{\w\}/ ;
        def sb = new StringBuffer();
        int i = 0;
        def sr = null
        while (s.find()) {
           if(vals.size()-1 <= i) vals << null;
           zparams << s.group().substring(1,2);
           s.appendReplacement(sb,"{"+(i++)+"}"); 
        } 
        s.appendTail(sb);
        return [template: sb.toString(), params:zparams, values: vals];
    }
    
    public boolean verifyValues() {
        if( origText == "{s}" ) {
            return true;
        }
        if( params && !values ) {
            return false;
        }
        return true;
    }
    
}