package com.rameses.gov.etracs.obo.models;

import com.rameses.rcp.annotations.*;
import com.rameses.rcp.common.*;
import com.rameses.seti2.models.*;
import com.rameses.util.*;
import com.rameses.osiris2.common.*;
import com.rameses.osiris2.client.*;
import com.rameses.rcp.framework.ClientContext;

public abstract class AppFormSectionListModel  {

    @Service("QueryService")
    def queryService;

    @Service("PersistenceService")
    def persistenceService;

    @Caller
    def caller;

    @Binding
    def binding;

    @Invoker
    def invoker;

    @Script("User")
    def user;
    
    def secProvider = ClientContext.getCurrentContext().getSecurityProvider();

    //caller is an instance of IFormContext
    public def getEntity() {
        return caller.entity;
    }

    public String getAppid() {
        return caller.appid;
    }

    public String getAppno() {
        return caller.appno;
    }

    public String getAppClassid() {
        return caller.appClassid;
    }

    public String getConnection() {
        return caller.connection;
    }
    
    public boolean isOrgroot() {
        return (OsirisContext.env.ORGROOT == 1 );
    }
    
    public String getOrgid() {
        return OsirisContext.getEnv().ORGID;
    }
    
    public String getSectionid() {
        if( caller.getFormContext() == "taskitem" )
            return entity.sectionid;
        else
            return null;        
    }

    public String getFormContext() {
        return caller.getFormContext();
    }

    public String getUserid() {
        return OsirisContext.getEnv().USERID;
    }
    
    public boolean hasRole( def role ) {
        return secProvider.checkPermission( "OBO", role, null );
    }
    
    public boolean isTaskAssignee() {
        return (caller.task?.assignee?.objid == userid);
    }

    public def getTaskAssigneeid() {
        return caller.task?.assignee?.objid;
    }

    public def getAppState() {
        return caller.getAppState();
    }

    public def getAppType() {
        return caller.getAppType();
    }

    public def getTask() {
        return caller.task;
    }

    public boolean isSameOrg( def org  ) {
        if( isOrgroot() ) {
            if ( org == null )
                return true;
            else 
                return false;    
        }
        else {
            if( org == null ) {
                return false;
            }
            else if ( getOrgid() == org ) 
                return true;
            else     
                return false; 
        }
    }

    public void init() {
        //override   
    }

    void refresh() {
        listHandler.reload();
    }

    def selectedItem;
    def listHandler = [
        isMultiSelect: {
            return isMultiSelect();
        },
        fetchList: { o->
            return fetchList( o );
        },
        openItem: { o,col->
            return viewItem();
        }
    ] as BasicListModel;


    public boolean validateBeforeRemove() {
        return MsgBox.confirm("You will be removing this entry. Please verify before continuing. Proceed?");    
    }
    final def removeItem() {
        if(!selectedItem) throw new Exception("Please select an item");
        if( !validateBeforeRemove() ) return null;
        removeItem( selectedItem );
        refresh();
    }

    final def viewItem() {
        if(!selectedItem) throw new Exception("Please select an item");
        return viewItem( selectedItem );
    }

    //overrides
    boolean isMultiSelect() {
        return false;
    }

    def fetchList( def o ) {
        return [];
    }

    def addItem() {
        throw new Exception("addItem not supported");
    }

    def viewItem( def o )  {
        throw new Exception("viewItem not supported");
    }

    void removeItem( def o )  {
        throw new Exception("removeItem not supported");
    }

    boolean getCanEdit() {
        return true;
    }

    boolean isVisible() {
        return true;
    }

}


