package com.rameses.gov.etracs.obo.components;

import com.rameses.rcp.annotations.*;
import com.rameses.rcp.common.*;
import com.rameses.osiris2.client.*;
import com.rameses.osiris2.client.OsirisContext
import com.rameses.osiris2.common.*;
import com.rameses.seti2.models.*;
import com.rameses.rcp.framework.ClientContext;

class OboAppProfessionalListModel extends BasicComponentModel {

    @Service("OboAppFeeService")
    def appFeeSvc;
    
    String schemaName= "obo_app_professional";
    def selectedItem;
    
    //this is needed by knowing which type of documents to add.
    def apptype;

    def getEntity() {
        return getValue();
    }
    
    public boolean getCanEdit() {
        if( apptype == "taskitem" ) {
            //if opening the document from the taskitem
            return (parentObject.task.assignee.objid == userid);
        }
        else if( isOrgroot() &&  hasRole("COORDINATOR") ) {
            return true; 
        }
        return false;
    }
    
    def openItem() {
        if(!selectedItem) throw new Exception("Please select an item");
        def p = [:];
        p.entity = selectedItem;
        def op = Inv.lookupOpener(schemaName + ":open", p );
        op.target = "popup";
        return op;
    }
    
    def formatProf( def o ) {
        if(!o.objid) return "";
        return o.lastname + "," + o.firstname + "(" + o.profession + "-" + o.prc.idno + ")";
    }
    
    def listHandler = [
        fetchList: { o->
            def m = [_schemaname: schemaName];
            m.findBy = [appid: entity.objid];
            def flist =  queryService.getList( m );
            return flist.collect{
                [ 
                    objid: it.objid,    
                    sectioninfo : (it.section?.title !=null) ? it.section.title : it.doctype,
                    designprofessionalinfo: formatProf(it.designprofessional),
                    supervisorinfo : formatProf(it.supervisor)
                ]
            }
        },
        openItem: { o,col->
            return openItem();
        }
    ] as BasicListModel;  
    
    
    void refresh() {
        listHandler.reload();
    }
    
    void addProfessional() {
        def section = null;
        def h = [:]
        h.onselect = { o->
            section = o;
        }
        h.listHandler = [
            fetchList: {
                def m = [_schemaname:"obo_section"];
                m.where = ["org.objid IS NULL"];
                return queryService.getList(m);
            },
            getColumns: {
                return [
                    [name:"objid", caption:"Section"],
                ];
            }
        ] as BasicListModel;
        h.title = "Please select a section";
        Modal.show( "simple_list_lookup" , h );
        if(!section)return;
        Modal.show("obo_app_professional:create", [section: section, appid: entity.objid ] );
        refresh();
    }
    
    void removeProfessional() {
        if(!selectedItem) throw new Exception("Please select an item first");
        if(!MsgBox.confirm("You will be removing this entry. Please verify before continuing. Continue?")) return;
        def m = [_schemaname: "obo_app_professional"];
        m.objid = selectedItem.objid;
        persistenceService.removeEntity(m);
        refresh();
    }
    
}
