package com.rameses.gov.etracs.obo.components;

import com.rameses.rcp.annotations.*;
import com.rameses.rcp.common.*;
import com.rameses.osiris2.client.*;
import com.rameses.osiris2.common.*;
import com.rameses.seti2.models.*;
import com.rameses.rcp.framework.ClientContext;
import com.rameses.util.*;

class BasicComponentModel extends ComponentBean {

    
    @Script("User")
    def user;
    
    def secProvider = ClientContext.getCurrentContext().getSecurityProvider();

    def _querySvc;
    def getQueryService() {
        if(!_querySvc) {
            _querySvc= InvokerProxy.getInstance().create("QueryService", null, connection);
        }
        return _querySvc;
    }
    
    def _persistenceSvc;
    def getPersistenceService() {
        if(!_persistenceSvc) {
            _persistenceSvc = InvokerProxy.getInstance().create("PersistenceService", null, connection);
        }
        return _persistenceSvc;
    }  
    
    def connection;
    boolean visible;
    boolean editable;
    
    void init() {
        
    }
    
    public boolean isOrgroot() {
        return (OsirisContext.env.ORGROOT == 1 );
    }
    
    public String getOrgid() {
        return OsirisContext.getEnv().ORGID;
    }
    
    public String getUserid() {
        return OsirisContext.getEnv().USERID;
    }
    
    public boolean hasRole( def role ) {
        return secProvider.checkPermission( "OBO", role, null );
    }
    
    public boolean isUserTaskAssignee() {
        return (parentObject.task?.assignee?.objid == userid);
    }
    
    void refresh() {
        
    }
    
}
