package com.rameses.jasper.models;

import com.rameses.rcp.annotations.*;
import com.rameses.rcp.common.*;
import com.rameses.seti2.models.*;
import com.rameses.osiris2.common.*;
import com.rameses.osiris2.client.*;
import com.rameses.util.*;
import com.rameses.common.*;
import com.rameses.rcp.constant.*;
import com.rameses.osiris2.reports.*;
import com.rameses.osiris2.report.*;
import java.text.*;

class SysReportTextPrintOutputRenderer extends SysReportOutputRenderer implements Runnable {
    
    int counter;
    int totalsize;
    boolean cancelled;
    boolean suspended;
    def iterator;

    boolean processing;

    def selectedPrinter;
    def printerService = new PrinterService();


    def init() {
        return "initial";
    }

    def selectPrinter() {
        return "default";
    }

    def progressBarHandler = [
        getMaxValue : {
            return totalsize;
        },
        getValue: {
            return counter;
        }
    ] as ProgressModel; 
	
    public def getPrinterList() {
       return printerService.getPrinters(); 
    }

    void start() {
        processing = true;
        cancelled= false;
        def data = super.getReportData();
        totalsize = data.size();
        counter = 0; 
        iterator = data.iterator();
        (new Thread(this)).start();
    }

    void resume() {
        processing = true;
        cancelled = false;
         (new Thread(this)).start();
    }

    void pause() {
        cancelled = true;
    }

    def exit() {
        return "_close";
    }

    boolean isEnded() {
        if(totalsize == 0) return false;    
        return (totalsize <= counter);    
    }   

    def stop() {
        processing = false;
        cancelled = true;
        if( MsgBox.confirm("You are about to stop this process. This will also close this window. Procced?") ) {
            return "_close";  
        }
        else {
            resume();
            return null;
        }
    }

    public void run() {
        while( !cancelled ) {
            if(!iterator.hasNext()) break;
            def data = iterator.next();
            
            def util = new SysReportTextPrintUtil();
            data.util = util;
            
            String txt = super.render( data );
           
            //subject corrected string to the util
            txt = util.finalizeFormat( txt );
            
            printerService.printString( selectedPrinter, txt );

            counter = counter + 1;
            if(binding) binding.refresh("progressLabel");
            progressBarHandler.refresh();
            Thread.sleep(200);
        }
        processing = false;
        binding.refresh();
    } 


}