package com.rameses.jasper.models;

import com.rameses.rcp.annotations.*;
import com.rameses.rcp.common.*;
import com.rameses.seti2.models.*;
import com.rameses.osiris2.common.*;
import com.rameses.util.*;
import com.rameses.osiris2.client.*;
import com.rameses.rcp.framework.*;
import com.rameses.osiris2.reports.*;
import net.sf.jasperreports.engine.*;
import net.sf.jasperreports.view.*;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileNameExtensionFilter;
import java.awt.*;

public class SysReportTemplateModel {

    @Caller
    def caller;
    
    @Binding
    def binding;
    
    def entity;
    def mode = "read";
    
    def filename;
    def folder;
    
    int templateOption;
    
    @PropertyChangeListener
    def listener = [
        "filename" : { o->
            entity.filepath = (!(folder) ? "" : folder) + ((!o)?"": "/"+o + ".jasper");
        },
        "folder": { o->
            entity.filepath = (!(o) ? "" : o) + ((!filename)?"": "/"+filename + ".jasper");
        }
    ];
    
    public String getConnection() {
        return caller.getConnection();
    }
    
    public def getReportTemplateService() {
        return InvokerProxy.instance.create("SysReportTemplateService", null, connection );
    }

    void create() {
        mode = "create";
        entity = [:];
        entity.master = 0;
        entity.masterfile = '/master-templates/blank.jrxml';
    }
    
    void open() {
        mode = "read";
        //split the filepath
        filename = entity.filepath.substring( entity.filepath.lastIndexOf("/")+1, entity.filepath.lastIndexOf(".") );
        folder = entity.filepath.substring(0, entity.filepath.lastIndexOf("/")); 
    }
    
    void edit() {
        mode = 'edit';
    }

    void save() {
        if ( mode == 'create' ) {
            if ( !entity.masterfile ) throw new Exception("Please select a master template");
        }
        
        if ( !MsgBox.confirm("You are about to save this template. Proceed?")) return;

        def result = null; 
        if ( mode == 'create' ) {
            result = reportTemplateService.create( entity );
        } else {
            result = reportTemplateService.update( entity );
        }
        
        if ( result instanceof Map ) {
            entity.clear(); 
            entity.putAll( result ); 
        }
        
        mode = "read";
    }
}