package com.rameses.jasper.models;

import com.rameses.rcp.annotations.*;
import com.rameses.rcp.common.*;
import com.rameses.seti2.models.*;
import com.rameses.osiris2.common.*;
import com.rameses.osiris2.client.*;
import com.rameses.osiris2.reports.*;
import com.rameses.util.*;
import com.rameses.common.*;
import com.rameses.rcp.constant.*;
import com.rameses.rcp.framework.UIViewHandler
import com.rameses.rcp.framework.UIViewPanel


class SysReportSubReportModel extends CrudFormModel {
    
    def reportDef;
    def parent;

    def queryTypes;

    public def getReportSvc() {
        return InvokerProxy.instance.create("SysReportDefService", null, connection );
    }
    
    public def getLovSvc() {
        return InvokerProxy.instance.create("LOVService", null, connection );
    }
    
    public String getConnection() {
        return caller.connection;
    }
    
    //this will reset the domain
    void afterInit() {
        queryTypes = getLovSvc().getKeyValues("REPORT_QUERY_TYPE")*.key;
        //domain = caller?.workunit?.workunit?.module?.getDomain();
    }
   
    void afterCreate() {
        entity.reportid = reportDef.name;
        if(parent) entity.parentid = parent.objid; 
    }
   
    /* 
    void afterOpen() {
        _initData();
    }
    */
    
    def testQuery() {
        def r = reportSvc.testQuery( [statement: entity.statement] );
        if(r.parameters) {
            MsgBox.alert("specify parameters " + r.parameters);
            return;        
        }
        MsgBox.alert("result is " + r.result);   
    } 
 
    def selectedSubReport;
    def subReportListHandler = [
        fetchList: { o->
            def m = [:];
            m._schemaname = "sys_report_subreport_def";
            m.where = ["parentid = :id", [id: entity.objid ]];
            return queryService.getList( m );
        }
    ] as BasicListModel;

    def addSubReport() {
        def p = [:];
        p.reportDef = reportDef;
        p.parent = entity;
        p.onSaveHandler = { o->
            subReportListHandler.reload();    
        };
        return Inv.lookupOpener( "sys_report_subreport_def:create", p );        
    }

    def editSubReport() {
        if(!selectedSubReport) throw new Exception("Subreport item must be selected");
        def p = [:];
        p.reportDef = entity;
        p.entity = selectedSubReport;
        p.connection = connection;
        p.onSaveHandler = { o->
            subReportListHandler.reload();    
        }
        return Inv.lookupOpener( "sys_report_subreport_def:open", p );        
    }

    def removeSubReport() {
        if(!selectedSubReport) throw new Exception("Subreport item must be selected");
        def m = [_schemaname: "sys_report_subreport_def"];
        m.findBy = [objid: selectedSubReport.objid];
        persistenceService.removeEntity( m );
        subReportListHandler.reload();    
    }
    

}