package com.rameses.jasper.models;

import com.rameses.rcp.annotations.*;
import com.rameses.rcp.common.*;
import com.rameses.seti2.models.*;
import com.rameses.osiris2.common.*;
import com.rameses.osiris2.client.*;
import com.rameses.osiris2.reports.*;
import com.rameses.util.*;
import com.rameses.common.*;
import com.rameses.rcp.constant.*;
import com.rameses.rcp.framework.UIViewHandler
import com.rameses.rcp.framework.UIViewPanel
import java.awt.*;

class SysReportOutputTemplateModel  {
    
    @Caller
    def caller;

    @Binding
    def binding;

    def mode = "create";

    def entity;
    def saveHandler;
    def types;
    def parentid;

    public def getPersistenceSvc() {
        return InvokerProxy.instance.create("PersistenceService", null, caller.getConnection() );
    }

    @PropertyChangeListener
    def listener = [
        "entity.type" : { o->
            if(mode=="create" && o) {
                entity.objid = parentid + ":" + o;
            }
            else if( !o) {
                entity.options = [:];
            }
            binding.refresh();
        }
    ];

    void loadTypes() {
        types = [];
        Inv.lookupOpeners("sys_report_output_template:types", [:]).each {
            types << it.properties.handler;
        }
    }
    
    void create() {
        mode = "create";
        entity = [:];
        entity.objid = parentid;
        entity.parentid = parentid;
        entity.options = [:];
        entity.printtype = 0;
        loadTypes();
    }

    void open() {
        loadTypes();
    }

    def doOk() {
        if( mode == "read" ) return "_close";
        entity._schemaname  = "sys_report_output_template";
        persistenceSvc.save( entity );   
        return "_close";
    }

    def doCancel() {
        return "_close";
    }

}