package com.rameses.jasper.models;

import com.rameses.rcp.annotations.*;
import com.rameses.rcp.common.*;
import com.rameses.seti2.models.*;
import com.rameses.osiris2.common.*;
import com.rameses.osiris2.common.*;
import com.rameses.osiris2.client.*;
import com.rameses.util.*;
import com.rameses.common.*;
import com.rameses.rcp.constant.*;
import com.rameses.osiris2.reports.*;
import net.sf.jasperreports.engine.*;
import groovy.text.*;

class SysReportOutputRenderer {
    
	@Invoker 
	def invoker;

	@Binding
	def binding;

    String reportid;
    def params;
	String connection;  

	def renderer;  

	public String getHandler() {
		return invoker.properties.handler;
	}

	public def getReportService() {
        return InvokerProxy.instance.create("SysReportService", null, connection );
    }
    
    public def getOutputTemplate() {
    	return getReportService().getOutputTemplate( [reportid: reportid, type: handler ] );
    }

    public def getReportData() {
    	return getReportService().getReportData( [name: reportid, params: params ] );
    }

    def init() {

    }

    public String render( def data  ) {
    	if(!renderer) {
    		def tmp = getOutputTemplate();
    		def templateEngine = new GStringTemplateEngine();
    		renderer = templateEngine.createTemplate( tmp.template ); 
    	}
        //this is just in case you want to use this style: ${it.name}. because if field exists not in this way, it will produce an error
        if( data instanceof Map ) {
            data.it = data;    
        }
    	return renderer.make( data ).toString();
    }

}